/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.client;

import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.rocketmq.broker.client.ClientChannelAttributeHelper;
import org.apache.rocketmq.broker.client.ClientChannelInfo;
import org.apache.rocketmq.broker.client.ConsumerGroupEvent;
import org.apache.rocketmq.broker.client.ConsumerGroupInfo;
import org.apache.rocketmq.broker.client.ConsumerIdsChangeListener;
import org.apache.rocketmq.common.BrokerConfig;
import org.apache.rocketmq.common.consumer.ConsumeFromWhere;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.protocol.heartbeat.ConsumeType;
import org.apache.rocketmq.remoting.protocol.heartbeat.MessageModel;
import org.apache.rocketmq.remoting.protocol.heartbeat.SubscriptionData;
import org.apache.rocketmq.store.stats.BrokerStatsManager;

public class ConsumerManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RocketmqBroker");
    private final ConcurrentMap<String, ConsumerGroupInfo> consumerTable = new ConcurrentHashMap<String, ConsumerGroupInfo>(1024);
    private final ConcurrentMap<String, Set<String>> topicGroupTable = new ConcurrentHashMap<String, Set<String>>(1024);
    private final ConcurrentMap<String, ConsumerGroupInfo> consumerCompensationTable = new ConcurrentHashMap<String, ConsumerGroupInfo>(1024);
    private final List<ConsumerIdsChangeListener> consumerIdsChangeListenerList = new CopyOnWriteArrayList<ConsumerIdsChangeListener>();
    protected final BrokerStatsManager brokerStatsManager;
    private final long channelExpiredTimeout;
    private final long subscriptionExpiredTimeout;
    private final BrokerConfig brokerConfig;

    public ConsumerManager(ConsumerIdsChangeListener consumerIdsChangeListener, long expiredTimeout) {
        this.consumerIdsChangeListenerList.add(consumerIdsChangeListener);
        this.brokerStatsManager = null;
        this.channelExpiredTimeout = expiredTimeout;
        this.subscriptionExpiredTimeout = expiredTimeout;
        this.brokerConfig = null;
    }

    public ConsumerManager(ConsumerIdsChangeListener consumerIdsChangeListener, BrokerStatsManager brokerStatsManager, BrokerConfig brokerConfig) {
        this.consumerIdsChangeListenerList.add(consumerIdsChangeListener);
        this.brokerStatsManager = brokerStatsManager;
        this.channelExpiredTimeout = brokerConfig.getChannelExpiredTimeout();
        this.subscriptionExpiredTimeout = brokerConfig.getSubscriptionExpiredTimeout();
        this.brokerConfig = brokerConfig;
    }

    public ClientChannelInfo findChannel(String group, String clientId) {
        ConsumerGroupInfo consumerGroupInfo = (ConsumerGroupInfo)this.consumerTable.get(group);
        if (consumerGroupInfo != null) {
            return consumerGroupInfo.findChannel(clientId);
        }
        return null;
    }

    public ClientChannelInfo findChannel(String group, Channel channel) {
        ConsumerGroupInfo consumerGroupInfo = (ConsumerGroupInfo)this.consumerTable.get(group);
        if (consumerGroupInfo != null) {
            return consumerGroupInfo.findChannel(channel);
        }
        return null;
    }

    public SubscriptionData findSubscriptionData(String group, String topic) {
        return this.findSubscriptionData(group, topic, true);
    }

    public SubscriptionData findSubscriptionData(String group, String topic, boolean fromCompensationTable) {
        ConsumerGroupInfo consumerGroupCompensationInfo;
        SubscriptionData subscriptionData;
        ConsumerGroupInfo consumerGroupInfo = this.getConsumerGroupInfo(group, false);
        if (consumerGroupInfo != null && (subscriptionData = consumerGroupInfo.findSubscriptionData(topic)) != null) {
            return subscriptionData;
        }
        if (fromCompensationTable && (consumerGroupCompensationInfo = (ConsumerGroupInfo)this.consumerCompensationTable.get(group)) != null) {
            return consumerGroupCompensationInfo.findSubscriptionData(topic);
        }
        return null;
    }

    public ConcurrentMap<String, ConsumerGroupInfo> getConsumerTable() {
        return this.consumerTable;
    }

    public ConsumerGroupInfo getConsumerGroupInfo(String group) {
        return this.getConsumerGroupInfo(group, false);
    }

    public ConsumerGroupInfo getConsumerGroupInfo(String group, boolean fromCompensationTable) {
        ConsumerGroupInfo consumerGroupInfo = (ConsumerGroupInfo)this.consumerTable.get(group);
        if (consumerGroupInfo == null && fromCompensationTable) {
            consumerGroupInfo = (ConsumerGroupInfo)this.consumerCompensationTable.get(group);
        }
        return consumerGroupInfo;
    }

    public int findSubscriptionDataCount(String group) {
        ConsumerGroupInfo consumerGroupInfo = this.getConsumerGroupInfo(group);
        if (consumerGroupInfo != null) {
            return consumerGroupInfo.getSubscriptionTable().size();
        }
        return 0;
    }

    public boolean doChannelCloseEvent(String remoteAddr, Channel channel) {
        boolean removed = false;
        if (this.brokerConfig != null && this.brokerConfig.isEnableFastChannelEventProcess()) {
            List<String> groups = ClientChannelAttributeHelper.getConsumerGroups(channel);
            if (this.brokerConfig.isPrintChannelGroups() && groups.size() >= 5 && groups.size() >= this.brokerConfig.getPrintChannelGroupsMinNum()) {
                LOGGER.warn("channel close event, too many consumer groups one channel, {}, {}, {}", new Object[]{groups.size(), remoteAddr, groups});
            }
            for (String group : groups) {
                ConsumerGroupInfo remove;
                ClientChannelInfo clientChannelInfo;
                ConsumerGroupInfo consumerGroupInfo;
                if (null == group || group.length() == 0 || null == (consumerGroupInfo = (ConsumerGroupInfo)this.consumerTable.get(group)) || (clientChannelInfo = consumerGroupInfo.doChannelCloseEvent(remoteAddr, channel)) == null) continue;
                removed = true;
                this.callConsumerIdsChangeListener(ConsumerGroupEvent.CLIENT_UNREGISTER, group, clientChannelInfo, consumerGroupInfo.getSubscribeTopics());
                if (consumerGroupInfo.getChannelInfoTable().isEmpty() && (remove = (ConsumerGroupInfo)this.consumerTable.remove(group)) != null) {
                    LOGGER.info("unregister consumer ok, no any connection, and remove consumer group, {}", (Object)group);
                    this.callConsumerIdsChangeListener(ConsumerGroupEvent.UNREGISTER, group, new Object[0]);
                    this.clearTopicGroupTable(remove);
                }
                this.callConsumerIdsChangeListener(ConsumerGroupEvent.CHANGE, group, consumerGroupInfo.getAllChannel());
            }
            return removed;
        }
        for (Map.Entry next : this.consumerTable.entrySet()) {
            ConsumerGroupInfo remove;
            ConsumerGroupInfo info = (ConsumerGroupInfo)next.getValue();
            ClientChannelInfo clientChannelInfo = info.doChannelCloseEvent(remoteAddr, channel);
            if (clientChannelInfo == null) continue;
            removed = true;
            this.callConsumerIdsChangeListener(ConsumerGroupEvent.CLIENT_UNREGISTER, (String)next.getKey(), clientChannelInfo, info.getSubscribeTopics());
            if (info.getChannelInfoTable().isEmpty() && (remove = (ConsumerGroupInfo)this.consumerTable.remove(next.getKey())) != null) {
                LOGGER.info("unregister consumer ok, no any connection, and remove consumer group, {}", next.getKey());
                this.callConsumerIdsChangeListener(ConsumerGroupEvent.UNREGISTER, (String)next.getKey(), new Object[0]);
                this.clearTopicGroupTable(remove);
            }
            if (this.isBroadcastMode(info.getMessageModel())) continue;
            this.callConsumerIdsChangeListener(ConsumerGroupEvent.CHANGE, (String)next.getKey(), info.getAllChannel());
        }
        return removed;
    }

    private void clearTopicGroupTable(ConsumerGroupInfo groupInfo) {
        for (String subscribeTopic : groupInfo.getSubscribeTopics()) {
            Set groups = (Set)this.topicGroupTable.get(subscribeTopic);
            if (groups != null) {
                groups.remove(groupInfo.getGroupName());
            }
            if (groups == null || !groups.isEmpty()) continue;
            this.topicGroupTable.remove(subscribeTopic);
        }
    }

    public void compensateBasicConsumerInfo(String group, ConsumeType consumeType, MessageModel messageModel) {
        ConsumerGroupInfo consumerGroupInfo = this.consumerCompensationTable.computeIfAbsent(group, ConsumerGroupInfo::new);
        consumerGroupInfo.setConsumeType(consumeType);
        consumerGroupInfo.setMessageModel(messageModel);
    }

    public void compensateSubscribeData(String group, String topic, SubscriptionData subscriptionData) {
        ConsumerGroupInfo consumerGroupInfo = this.consumerCompensationTable.computeIfAbsent(group, ConsumerGroupInfo::new);
        consumerGroupInfo.getSubscriptionTable().put(topic, subscriptionData);
    }

    public boolean registerConsumer(String group, ClientChannelInfo clientChannelInfo, ConsumeType consumeType, MessageModel messageModel, ConsumeFromWhere consumeFromWhere, Set<SubscriptionData> subList, boolean isNotifyConsumerIdsChangedEnable) {
        return this.registerConsumer(group, clientChannelInfo, consumeType, messageModel, consumeFromWhere, subList, isNotifyConsumerIdsChangedEnable, true);
    }

    public boolean registerConsumer(String group, ClientChannelInfo clientChannelInfo, ConsumeType consumeType, MessageModel messageModel, ConsumeFromWhere consumeFromWhere, Set<SubscriptionData> subList, boolean isNotifyConsumerIdsChangedEnable, boolean updateSubscription) {
        long start = System.currentTimeMillis();
        Object consumerGroupInfo = (ConsumerGroupInfo)this.consumerTable.get(group);
        if (null == consumerGroupInfo) {
            ConsumerGroupInfo tmp = new ConsumerGroupInfo(group, consumeType, messageModel, consumeFromWhere);
            ConsumerGroupInfo prev = this.consumerTable.putIfAbsent(group, tmp);
            consumerGroupInfo = prev != null ? prev : tmp;
        }
        for (SubscriptionData subscriptionData : subList) {
            HashSet<String> groups = (HashSet<String>)this.topicGroupTable.get(subscriptionData.getTopic());
            if (groups == null) {
                HashSet<String> tmp = new HashSet<String>();
                HashSet<String> prev = this.topicGroupTable.putIfAbsent(subscriptionData.getTopic(), tmp);
                groups = prev != null ? prev : tmp;
            }
            groups.add(group);
        }
        boolean r1 = ((ConsumerGroupInfo)consumerGroupInfo).updateChannel(clientChannelInfo, consumeType, messageModel, consumeFromWhere);
        if (r1) {
            this.callConsumerIdsChangeListener(ConsumerGroupEvent.CLIENT_REGISTER, group, clientChannelInfo, subList.stream().map(SubscriptionData::getTopic).collect(Collectors.toSet()));
        }
        boolean r2 = false;
        if (updateSubscription) {
            r2 = ((ConsumerGroupInfo)consumerGroupInfo).updateSubscription(subList);
        }
        if ((r1 || r2) && isNotifyConsumerIdsChangedEnable && !this.isBroadcastMode(((ConsumerGroupInfo)consumerGroupInfo).getMessageModel())) {
            this.callConsumerIdsChangeListener(ConsumerGroupEvent.CHANGE, group, ((ConsumerGroupInfo)consumerGroupInfo).getAllChannel());
        }
        if (this.brokerConfig != null && this.brokerConfig.isEnableFastChannelEventProcess() && r1) {
            ClientChannelAttributeHelper.addConsumerGroup(clientChannelInfo.getChannel(), group);
        }
        if (null != this.brokerStatsManager) {
            this.brokerStatsManager.incConsumerRegisterTime((int)(System.currentTimeMillis() - start));
        }
        this.callConsumerIdsChangeListener(ConsumerGroupEvent.REGISTER, group, subList, clientChannelInfo);
        return r1 || r2;
    }

    public boolean registerConsumerWithoutSub(String group, ClientChannelInfo clientChannelInfo, ConsumeType consumeType, MessageModel messageModel, ConsumeFromWhere consumeFromWhere, boolean isNotifyConsumerIdsChangedEnable) {
        long start = System.currentTimeMillis();
        Object consumerGroupInfo = (ConsumerGroupInfo)this.consumerTable.get(group);
        if (null == consumerGroupInfo) {
            ConsumerGroupInfo tmp = new ConsumerGroupInfo(group, consumeType, messageModel, consumeFromWhere);
            ConsumerGroupInfo prev = this.consumerTable.putIfAbsent(group, tmp);
            consumerGroupInfo = prev != null ? prev : tmp;
        }
        for (SubscriptionData subscriptionData : ((ConsumerGroupInfo)consumerGroupInfo).getSubscriptionTable().values()) {
            HashSet<String> groups = (HashSet<String>)this.topicGroupTable.get(subscriptionData.getTopic());
            if (groups == null) {
                HashSet<String> tmp = new HashSet<String>();
                HashSet<String> prev = this.topicGroupTable.putIfAbsent(subscriptionData.getTopic(), tmp);
                groups = prev != null ? prev : tmp;
            }
            groups.add(group);
        }
        boolean updateChannelRst = ((ConsumerGroupInfo)consumerGroupInfo).updateChannel(clientChannelInfo, consumeType, messageModel, consumeFromWhere);
        if (updateChannelRst && isNotifyConsumerIdsChangedEnable && !this.isBroadcastMode(((ConsumerGroupInfo)consumerGroupInfo).getMessageModel())) {
            this.callConsumerIdsChangeListener(ConsumerGroupEvent.CHANGE, group, ((ConsumerGroupInfo)consumerGroupInfo).getAllChannel());
        }
        if (null != this.brokerStatsManager) {
            this.brokerStatsManager.incConsumerRegisterTime((int)(System.currentTimeMillis() - start));
        }
        return updateChannelRst;
    }

    public void unregisterConsumer(String group, ClientChannelInfo clientChannelInfo, boolean isNotifyConsumerIdsChangedEnable) {
        ConsumerGroupInfo consumerGroupInfo = (ConsumerGroupInfo)this.consumerTable.get(group);
        if (null != consumerGroupInfo) {
            ConsumerGroupInfo remove;
            boolean removed = consumerGroupInfo.unregisterChannel(clientChannelInfo);
            if (removed) {
                this.callConsumerIdsChangeListener(ConsumerGroupEvent.CLIENT_UNREGISTER, group, clientChannelInfo, consumerGroupInfo.getSubscribeTopics());
            }
            if (consumerGroupInfo.getChannelInfoTable().isEmpty() && (remove = (ConsumerGroupInfo)this.consumerTable.remove(group)) != null) {
                LOGGER.info("unregister consumer ok, no any connection, and remove consumer group, {}", (Object)group);
                this.callConsumerIdsChangeListener(ConsumerGroupEvent.UNREGISTER, group, new Object[0]);
                this.clearTopicGroupTable(remove);
            }
            if (isNotifyConsumerIdsChangedEnable && !this.isBroadcastMode(consumerGroupInfo.getMessageModel())) {
                this.callConsumerIdsChangeListener(ConsumerGroupEvent.CHANGE, group, consumerGroupInfo.getAllChannel());
            }
        }
    }

    public void removeExpireConsumerGroupInfo() {
        ArrayList removeList = new ArrayList();
        this.consumerCompensationTable.forEach((group, consumerGroupInfo) -> {
            ArrayList removeTopicList = new ArrayList();
            ConcurrentMap<String, SubscriptionData> subscriptionTable = consumerGroupInfo.getSubscriptionTable();
            subscriptionTable.forEach((topic, subscriptionData) -> {
                long diff = System.currentTimeMillis() - subscriptionData.getSubVersion();
                if (diff > this.subscriptionExpiredTimeout) {
                    removeTopicList.add(topic);
                }
            });
            for (String topic2 : removeTopicList) {
                subscriptionTable.remove(topic2);
                if (!subscriptionTable.isEmpty()) continue;
                removeList.add(group);
            }
        });
        for (String group2 : removeList) {
            this.consumerCompensationTable.remove(group2);
        }
    }

    public void scanNotActiveChannel() {
        Iterator it = this.consumerTable.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            String group = (String)next.getKey();
            ConsumerGroupInfo consumerGroupInfo = (ConsumerGroupInfo)next.getValue();
            ConcurrentMap<Channel, ClientChannelInfo> channelInfoTable = consumerGroupInfo.getChannelInfoTable();
            Iterator itChannel = channelInfoTable.entrySet().iterator();
            while (itChannel.hasNext()) {
                Map.Entry nextChannel = itChannel.next();
                ClientChannelInfo clientChannelInfo = (ClientChannelInfo)nextChannel.getValue();
                long diff = System.currentTimeMillis() - clientChannelInfo.getLastUpdateTimestamp();
                if (diff <= this.channelExpiredTimeout) continue;
                LOGGER.warn("SCAN: remove expired channel from ConsumerManager consumerTable. channel={}, consumerGroup={}", (Object)RemotingHelper.parseChannelRemoteAddr((Channel)clientChannelInfo.getChannel()), (Object)group);
                this.callConsumerIdsChangeListener(ConsumerGroupEvent.CLIENT_UNREGISTER, group, clientChannelInfo, consumerGroupInfo.getSubscribeTopics());
                RemotingHelper.closeChannel((Channel)clientChannelInfo.getChannel());
                itChannel.remove();
            }
            if (!channelInfoTable.isEmpty()) continue;
            LOGGER.warn("SCAN: remove expired channel from ConsumerManager consumerTable, all clear, consumerGroup={}", (Object)group);
            it.remove();
        }
        this.removeExpireConsumerGroupInfo();
    }

    public HashSet<String> queryTopicConsumeByWho(String topic) {
        return new HashSet<String>(Optional.ofNullable(this.topicGroupTable.get(topic)).orElseGet(HashSet::new));
    }

    public void appendConsumerIdsChangeListener(ConsumerIdsChangeListener listener) {
        this.consumerIdsChangeListenerList.add(listener);
    }

    protected void callConsumerIdsChangeListener(ConsumerGroupEvent event, String group, Object ... args) {
        for (ConsumerIdsChangeListener listener : this.consumerIdsChangeListenerList) {
            try {
                listener.handle(event, group, args);
            }
            catch (Throwable t) {
                LOGGER.error("err when call consumerIdsChangeListener", t);
            }
        }
    }

    private boolean isBroadcastMode(MessageModel messageModel) {
        return MessageModel.BROADCASTING.equals((Object)messageModel);
    }
}

