/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.queue;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.BoundaryType;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.Pair;
import org.apache.rocketmq.common.ServiceState;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.DispatchRequest;
import org.apache.rocketmq.store.config.StorePathConfigHelper;
import org.apache.rocketmq.store.exception.ConsumeQueueException;
import org.apache.rocketmq.store.exception.StoreException;
import org.apache.rocketmq.store.queue.AbstractConsumeQueueStore;
import org.apache.rocketmq.store.queue.ConsumeQueueInterface;
import org.apache.rocketmq.store.queue.DispatchEntry;
import org.apache.rocketmq.store.queue.OffsetInitializer;
import org.apache.rocketmq.store.queue.OffsetInitializerRocksDBImpl;
import org.apache.rocketmq.store.queue.RocksDBConsumeQueue;
import org.apache.rocketmq.store.queue.RocksDBConsumeQueueOffsetTable;
import org.apache.rocketmq.store.queue.RocksDBConsumeQueueTable;
import org.apache.rocketmq.store.queue.RocksGroupCommitService;
import org.apache.rocketmq.store.rocksdb.ConsumeQueueRocksDBStorage;
import org.rocksdb.FlushOptions;
import org.rocksdb.RocksDBException;
import org.rocksdb.Statistics;
import org.rocksdb.WriteBatch;

public class RocksDBConsumeQueueStore
extends AbstractConsumeQueueStore {
    private static final Logger ERROR_LOG = LoggerFactory.getLogger((String)"RocketmqStoreError");
    private static final Logger ROCKSDB_LOG = LoggerFactory.getLogger((String)"RocketmqRocksDB");
    private static final int DEFAULT_BYTE_BUFFER_CAPACITY = 16;
    public static final int MAX_KEY_LEN = 300;
    private final ScheduledExecutorService scheduledExecutorService;
    private final String storePath;
    private final ConsumeQueueRocksDBStorage rocksDBStorage;
    private final RocksDBConsumeQueueTable rocksDBConsumeQueueTable;
    private final RocksDBConsumeQueueOffsetTable rocksDBConsumeQueueOffsetTable;
    private final List<Pair<ByteBuffer, ByteBuffer>> cqBBPairList;
    private final List<Pair<ByteBuffer, ByteBuffer>> offsetBBPairList;
    private final Map<ByteBuffer, Pair<ByteBuffer, DispatchEntry>> tempTopicQueueMaxOffsetMap;
    private volatile boolean isCQError = false;
    private int consumeQueueByteBufferCacheIndex;
    private int offsetBufferCacheIndex;
    private final OffsetInitializer offsetInitializer;
    private final RocksGroupCommitService groupCommitService;
    private final AtomicReference<ServiceState> serviceState = new AtomicReference<ServiceState>(ServiceState.CREATE_JUST);

    public RocksDBConsumeQueueStore(DefaultMessageStore messageStore) {
        super(messageStore);
        this.storePath = StorePathConfigHelper.getStorePathConsumeQueue(this.messageStoreConfig.getStorePathRootDir());
        this.rocksDBStorage = new ConsumeQueueRocksDBStorage(messageStore, this.storePath);
        this.rocksDBConsumeQueueTable = new RocksDBConsumeQueueTable(this.rocksDBStorage, messageStore);
        this.rocksDBConsumeQueueOffsetTable = new RocksDBConsumeQueueOffsetTable(this.rocksDBConsumeQueueTable, this.rocksDBStorage, messageStore);
        this.offsetInitializer = new OffsetInitializerRocksDBImpl(this);
        this.groupCommitService = new RocksGroupCommitService(this);
        this.cqBBPairList = new ArrayList<Pair<ByteBuffer, ByteBuffer>>(16);
        this.offsetBBPairList = new ArrayList<Pair<ByteBuffer, ByteBuffer>>(16);
        for (int i = 0; i < 16; ++i) {
            this.cqBBPairList.add(RocksDBConsumeQueueTable.getCQByteBufferPair());
            this.offsetBBPairList.add(RocksDBConsumeQueueOffsetTable.getOffsetByteBufferPair());
        }
        this.tempTopicQueueMaxOffsetMap = new HashMap<ByteBuffer, Pair<ByteBuffer, DispatchEntry>>();
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new ThreadFactoryImpl("RocksDBConsumeQueueStoreScheduledThread", messageStore.getBrokerIdentity()));
    }

    private Pair<ByteBuffer, ByteBuffer> getCQByteBufferPair() {
        int idx;
        if ((idx = this.consumeQueueByteBufferCacheIndex++) >= this.cqBBPairList.size()) {
            this.cqBBPairList.add(RocksDBConsumeQueueTable.getCQByteBufferPair());
        }
        return this.cqBBPairList.get(idx);
    }

    private Pair<ByteBuffer, ByteBuffer> getOffsetByteBufferPair() {
        int idx;
        if ((idx = this.offsetBufferCacheIndex++) >= this.offsetBBPairList.size()) {
            this.offsetBBPairList.add(RocksDBConsumeQueueOffsetTable.getOffsetByteBufferPair());
        }
        return this.offsetBBPairList.get(idx);
    }

    @Override
    public void start() {
        if (this.serviceState.compareAndSet(ServiceState.CREATE_JUST, ServiceState.RUNNING)) {
            log.info("RocksDB ConsumeQueueStore start!");
            this.groupCommitService.start();
            this.scheduledExecutorService.scheduleAtFixedRate(() -> this.rocksDBStorage.statRocksdb(ROCKSDB_LOG), 10L, this.messageStoreConfig.getStatRocksDBCQIntervalSec(), TimeUnit.SECONDS);
            this.scheduledExecutorService.scheduleWithFixedDelay(() -> this.cleanDirty(this.messageStore.getTopicConfigs().keySet()), 10L, this.messageStoreConfig.getCleanRocksDBDirtyCQIntervalMin(), TimeUnit.MINUTES);
        }
    }

    private void cleanDirty(Set<String> existTopicSet) {
        try {
            Map<String, Set<Integer>> topicQueueIdToBeDeletedMap = this.rocksDBConsumeQueueOffsetTable.iterateOffsetTable2FindDirty(existTopicSet);
            for (Map.Entry<String, Set<Integer>> entry : topicQueueIdToBeDeletedMap.entrySet()) {
                String topic = entry.getKey();
                for (int queueId : entry.getValue()) {
                    this.destroy(new RocksDBConsumeQueue(topic, queueId));
                }
            }
        }
        catch (Exception e) {
            log.error("cleanUnusedTopic Failed.", (Throwable)e);
        }
    }

    @Override
    public boolean load() {
        boolean result = this.rocksDBStorage.start();
        this.rocksDBConsumeQueueTable.load();
        this.rocksDBConsumeQueueOffsetTable.load();
        log.info("load rocksdb consume queue {}.", (Object)(result ? "OK" : "Failed"));
        return result;
    }

    @Override
    public boolean loadAfterDestroy() {
        return this.load();
    }

    @Override
    public void recover() {
        this.start();
    }

    @Override
    public boolean recoverConcurrently() {
        this.start();
        return true;
    }

    @Override
    public boolean shutdown() {
        if (this.serviceState.compareAndSet(ServiceState.RUNNING, ServiceState.SHUTDOWN_ALREADY)) {
            this.groupCommitService.shutdown();
            this.scheduledExecutorService.shutdown();
            return this.shutdownInner();
        }
        return true;
    }

    private boolean shutdownInner() {
        return this.rocksDBStorage.shutdown();
    }

    @Override
    public void putMessagePositionInfoWrapper(DispatchRequest request) throws RocksDBException {
        if (null == request) {
            return;
        }
        try {
            this.groupCommitService.putRequest(request);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void putMessagePosition(List<DispatchRequest> requests) throws RocksDBException {
        int maxRetries = 30;
        for (int i = 0; i < 30; ++i) {
            if (this.putMessagePosition0(requests)) {
                if (this.isCQError) {
                    this.messageStore.getRunningFlags().clearLogicsQueueError();
                    this.isCQError = false;
                }
                return;
            }
            ERROR_LOG.warn("Put cq Failed. retryTime: {}", (Object)i);
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!this.isCQError) {
            ERROR_LOG.error("[BUG] put CQ Failed.");
            this.messageStore.getRunningFlags().makeLogicsQueueError();
            this.isCQError = true;
        }
        throw new RocksDBException("put CQ Failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean putMessagePosition0(List<DispatchRequest> requests) {
        if (!this.rocksDBStorage.hold()) {
            return false;
        }
        try {
            boolean bl;
            Throwable throwable;
            WriteBatch writeBatch;
            block26: {
                block27: {
                    block23: {
                        boolean bl2;
                        block24: {
                            block25: {
                                writeBatch = new WriteBatch();
                                throwable = null;
                                int size = requests.size();
                                if (size != 0) break block23;
                                bl2 = true;
                                if (writeBatch == null) break block24;
                                if (throwable == null) break block25;
                                try {
                                    writeBatch.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block24;
                            }
                            writeBatch.close();
                        }
                        return bl2;
                    }
                    long maxPhyOffset = 0L;
                    for (int i = size - 1; i >= 0; --i) {
                        DispatchRequest request = requests.get(i);
                        DispatchEntry entry = DispatchEntry.from(request);
                        this.dispatch(entry, writeBatch);
                        this.dispatchLMQ(request, writeBatch);
                        int msgSize = request.getMsgSize();
                        long phyOffset = request.getCommitLogOffset();
                        if (phyOffset + (long)msgSize < maxPhyOffset) continue;
                        maxPhyOffset = phyOffset + (long)msgSize;
                    }
                    this.rocksDBConsumeQueueOffsetTable.putMaxPhyAndCqOffset(this.tempTopicQueueMaxOffsetMap, writeBatch, maxPhyOffset);
                    this.rocksDBStorage.batchPut(writeBatch);
                    this.rocksDBConsumeQueueOffsetTable.putHeapMaxCqOffset(this.tempTopicQueueMaxOffsetMap);
                    this.notifyMessageArriveAndClear(requests);
                    bl = true;
                    if (writeBatch == null) break block26;
                    if (throwable == null) break block27;
                    try {
                        writeBatch.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    break block26;
                }
                writeBatch.close();
            }
            return bl;
            catch (Throwable throwable4) {
                try {
                    try {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        if (writeBatch != null) {
                            if (throwable != null) {
                                try {
                                    writeBatch.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                            } else {
                                writeBatch.close();
                            }
                        }
                        throw throwable5;
                    }
                }
                catch (Exception e) {
                    ERROR_LOG.error("putMessagePosition0 failed.", (Throwable)e);
                    boolean bl3 = false;
                    return bl3;
                }
            }
        }
        finally {
            this.tempTopicQueueMaxOffsetMap.clear();
            this.consumeQueueByteBufferCacheIndex = 0;
            this.offsetBufferCacheIndex = 0;
            this.rocksDBStorage.release();
        }
    }

    private void dispatch(@Nonnull DispatchEntry entry, @Nonnull WriteBatch writeBatch) throws RocksDBException {
        this.rocksDBConsumeQueueTable.buildAndPutCQByteBuffer(this.getCQByteBufferPair(), entry, writeBatch);
        this.updateTempTopicQueueMaxOffset(this.getOffsetByteBufferPair(), entry);
    }

    private void updateTempTopicQueueMaxOffset(Pair<ByteBuffer, ByteBuffer> offsetBBPair, DispatchEntry entry) {
        RocksDBConsumeQueueOffsetTable.buildOffsetKeyAndValueByteBuffer(offsetBBPair, entry);
        ByteBuffer topicQueueId = (ByteBuffer)offsetBBPair.getObject1();
        ByteBuffer maxOffsetBB = (ByteBuffer)offsetBBPair.getObject2();
        Pair<ByteBuffer, DispatchEntry> old = this.tempTopicQueueMaxOffsetMap.get(topicQueueId);
        if (old == null) {
            this.tempTopicQueueMaxOffsetMap.put(topicQueueId, (Pair<ByteBuffer, DispatchEntry>)new Pair((Object)maxOffsetBB, (Object)entry));
        } else {
            long oldMaxOffset = ((ByteBuffer)old.getObject1()).getLong(8);
            long maxOffset = maxOffsetBB.getLong(8);
            if (maxOffset >= oldMaxOffset) {
                ERROR_LOG.error("cqOffset invalid1. old: {}, now: {}", (Object)oldMaxOffset, (Object)maxOffset);
            }
        }
    }

    private void dispatchLMQ(@Nonnull DispatchRequest request, @Nonnull WriteBatch writeBatch) throws RocksDBException {
        String[] queueOffsets;
        if (!this.messageStoreConfig.isEnableLmq() || !request.containsLMQ()) {
            return;
        }
        Map<String, String> map = request.getPropertiesMap();
        String lmqNames = map.get("INNER_MULTI_DISPATCH");
        String lmqOffsets = map.get("INNER_MULTI_QUEUE_OFFSET");
        String[] queues = lmqNames.split(",");
        if (queues.length != (queueOffsets = lmqOffsets.split(",")).length) {
            ERROR_LOG.error("[bug] queues.length!=queueOffsets.length ", (Object)request.getTopic());
            return;
        }
        for (int i = 0; i < queues.length; ++i) {
            String queueName = queues[i];
            DispatchEntry entry = DispatchEntry.from(request);
            long queueOffset = Long.parseLong(queueOffsets[i]);
            int queueId = request.getQueueId();
            if (this.messageStore.getMessageStoreConfig().isEnableLmq() && MixAll.isLmq((String)queueName)) {
                queueId = 0;
            }
            entry.queueId = queueId;
            entry.queueOffset = queueOffset;
            entry.topic = queueName.getBytes(StandardCharsets.UTF_8);
            log.debug("Dispatch LMQ[{}:{}]:{} --> {}", new Object[]{queueName, queueId, queueOffset, entry.commitLogOffset});
            this.dispatch(entry, writeBatch);
        }
    }

    private void notifyMessageArriveAndClear(List<DispatchRequest> requests) {
        try {
            for (DispatchRequest dp : requests) {
                this.messageStore.notifyMessageArriveIfNecessary(dp);
            }
            requests.clear();
        }
        catch (Exception e) {
            ERROR_LOG.error("notifyMessageArriveAndClear Failed.", (Throwable)e);
        }
    }

    public Statistics getStatistics() {
        return this.rocksDBStorage.getStatistics();
    }

    @Override
    public List<ByteBuffer> rangeQuery(String topic, int queueId, long startIndex, int num) throws RocksDBException {
        return this.rocksDBConsumeQueueTable.rangeQuery(topic, queueId, startIndex, num);
    }

    @Override
    public ByteBuffer get(String topic, int queueId, long cqOffset) throws RocksDBException {
        return this.rocksDBConsumeQueueTable.getCQInKV(topic, queueId, cqOffset);
    }

    @Override
    public void recoverOffsetTable(long minPhyOffset) {
    }

    @Override
    public void destroy() {
        try {
            this.shutdownInner();
            FileUtils.deleteDirectory((File)new File(this.storePath));
        }
        catch (Exception e) {
            ERROR_LOG.error("destroy cq Failed. {}", (Object)this.storePath, (Object)e);
        }
    }

    @Override
    public void destroy(ConsumeQueueInterface consumeQueue) throws RocksDBException {
        String topic = consumeQueue.getTopic();
        int queueId = consumeQueue.getQueueId();
        if (StringUtils.isEmpty((CharSequence)topic) || queueId < 0 || !this.rocksDBStorage.hold()) {
            return;
        }
        try (WriteBatch writeBatch = new WriteBatch();){
            this.rocksDBConsumeQueueTable.destroyCQ(topic, queueId, writeBatch);
            this.rocksDBConsumeQueueOffsetTable.destroyOffset(topic, queueId, writeBatch);
            this.rocksDBStorage.batchPut(writeBatch);
        }
        catch (RocksDBException e) {
            ERROR_LOG.error("kv deleteTopic {} Failed.", (Object)topic, (Object)e);
            throw e;
        }
        finally {
            this.rocksDBStorage.release();
        }
    }

    @Override
    public boolean flush(ConsumeQueueInterface consumeQueue, int flushLeastPages) {
        try {
            this.rocksDBStorage.flushWAL();
        }
        catch (Exception e) {
            log.error("Failed to flush WAL", (Throwable)e);
        }
        return true;
    }

    @Override
    public void flush() throws StoreException {
        try (FlushOptions flushOptions = new FlushOptions();){
            flushOptions.setWaitForFlush(true);
            flushOptions.setAllowWriteStall(true);
            this.rocksDBStorage.flush(flushOptions);
        }
        catch (RocksDBException e) {
            throw new StoreException(e);
        }
    }

    @Override
    public void checkSelf() {
    }

    @Override
    public int deleteExpiredFile(ConsumeQueueInterface consumeQueue, long minCommitLogPos) {
        return 0;
    }

    @Override
    public void truncateDirty(long offsetToTruncate) throws RocksDBException {
        long maxPhyOffsetInRocksdb = this.getMaxPhyOffsetInConsumeQueue();
        if (offsetToTruncate >= maxPhyOffsetInRocksdb) {
            return;
        }
        this.rocksDBConsumeQueueOffsetTable.truncateDirty(offsetToTruncate);
    }

    @Override
    public void cleanExpired(long minPhyOffset) {
        this.rocksDBStorage.manualCompaction(minPhyOffset);
    }

    @Override
    public long getOffsetInQueueByTime(String topic, int queueId, long timestamp, BoundaryType boundaryType) throws RocksDBException {
        long minPhysicOffset = this.messageStore.getMinPhyOffset();
        long low = this.rocksDBConsumeQueueOffsetTable.getMinCqOffset(topic, queueId);
        Long high = this.rocksDBConsumeQueueOffsetTable.getMaxCqOffset(topic, queueId);
        if (high == null || high == -1L) {
            return 0L;
        }
        return this.rocksDBConsumeQueueTable.binarySearchInCQByTime(topic, queueId, high, low, timestamp, minPhysicOffset, boundaryType);
    }

    @Override
    public long getMaxOffsetInQueue(String topic, int queueId) throws RocksDBException {
        Long maxOffset = this.rocksDBConsumeQueueOffsetTable.getMaxCqOffset(topic, queueId);
        return maxOffset != null ? maxOffset + 1L : 0L;
    }

    @Override
    public long getMinOffsetInQueue(String topic, int queueId) throws RocksDBException {
        return this.rocksDBConsumeQueueOffsetTable.getMinCqOffset(topic, queueId);
    }

    @Override
    public Long getMaxPhyOffsetInConsumeQueue(String topic, int queueId) {
        return this.rocksDBConsumeQueueOffsetTable.getMaxPhyOffset(topic, queueId);
    }

    @Override
    public long getMaxPhyOffsetInConsumeQueue() throws RocksDBException {
        return this.rocksDBConsumeQueueOffsetTable.getMaxPhyOffset();
    }

    @Override
    public ConsumeQueueInterface findOrCreateConsumeQueue(String topic, int queueId) {
        ConsumeQueueInterface logic;
        ConcurrentMap<Integer, RocksDBConsumeQueue> map = (ConcurrentHashMap<Integer, RocksDBConsumeQueue>)this.consumeQueueTable.get(topic);
        if (null == map) {
            ConcurrentHashMap<Integer, RocksDBConsumeQueue> newMap = MixAll.isLmq((String)topic) ? new ConcurrentHashMap(1, 1.0f) : new ConcurrentHashMap<Integer, RocksDBConsumeQueue>(8);
            ConcurrentMap oldMap = this.consumeQueueTable.putIfAbsent(topic, newMap);
            map = oldMap != null ? oldMap : newMap;
        }
        if ((logic = (ConsumeQueueInterface)map.get(queueId)) != null) {
            return logic;
        }
        RocksDBConsumeQueue newLogic = new RocksDBConsumeQueue(this.messageStore, topic, queueId);
        ConsumeQueueInterface oldLogic = map.putIfAbsent(queueId, newLogic);
        return oldLogic != null ? oldLogic : newLogic;
    }

    @Override
    public long rollNextFile(ConsumeQueueInterface consumeQueue, long offset) {
        return 0L;
    }

    @Override
    public boolean isFirstFileExist(ConsumeQueueInterface consumeQueue) {
        return true;
    }

    @Override
    public boolean isFirstFileAvailable(ConsumeQueueInterface consumeQueue) {
        return true;
    }

    @Override
    public long getTotalSize() {
        return 0L;
    }

    @Override
    public long getLmqQueueOffset(String topic, int queueId) throws ConsumeQueueException {
        return this.queueOffsetOperator.getLmqOffset(topic, queueId, this.offsetInitializer);
    }

    @Override
    public Long getMaxOffset(String topic, int queueId) throws ConsumeQueueException {
        if (MixAll.isLmq((String)topic)) {
            return this.getLmqQueueOffset(topic, queueId);
        }
        return super.getMaxOffset(topic, queueId);
    }

    public boolean isStopped() {
        return ServiceState.SHUTDOWN_ALREADY == this.serviceState.get();
    }
}

