/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.common;

import com.google.common.cache.CacheLoader;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Nonnull;

public abstract class AbstractCacheLoader<K, V>
extends CacheLoader<K, V> {
    private final ThreadPoolExecutor cacheRefreshExecutor;

    public AbstractCacheLoader(ThreadPoolExecutor cacheRefreshExecutor) {
        this.cacheRefreshExecutor = cacheRefreshExecutor;
    }

    public ListenableFuture<V> reload(@Nonnull K key, @Nonnull V oldValue) throws Exception {
        ListenableFutureTask task = ListenableFutureTask.create(() -> {
            try {
                return this.getDirectly(key);
            }
            catch (Exception e) {
                this.onErr(key, e);
                return oldValue;
            }
        });
        this.cacheRefreshExecutor.execute((Runnable)task);
        return task;
    }

    public V load(@Nonnull K key) throws Exception {
        return this.getDirectly(key);
    }

    protected abstract V getDirectly(K var1) throws Exception;

    protected abstract void onErr(K var1, Exception var2);
}

