/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.protocol.header;

import com.google.common.base.MoreObjects;
import org.apache.rocketmq.common.action.Action;
import org.apache.rocketmq.common.action.RocketMQAction;
import org.apache.rocketmq.common.resource.ResourceType;
import org.apache.rocketmq.common.resource.RocketMQResource;
import org.apache.rocketmq.remoting.annotation.CFNotNull;
import org.apache.rocketmq.remoting.annotation.CFNullable;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.header.SendMessageRequestHeaderV2;
import org.apache.rocketmq.remoting.rpc.TopicQueueRequestHeader;

@RocketMQAction(value=10, action={Action.PUB})
public class SendMessageRequestHeader
extends TopicQueueRequestHeader {
    @CFNotNull
    private String producerGroup;
    @CFNotNull
    @RocketMQResource(value=ResourceType.TOPIC)
    private String topic;
    @CFNotNull
    private String defaultTopic;
    @CFNotNull
    private Integer defaultTopicQueueNums;
    @CFNotNull
    private Integer queueId;
    @CFNotNull
    private Integer sysFlag;
    @CFNotNull
    private Long bornTimestamp;
    @CFNotNull
    private Integer flag;
    @CFNullable
    private String properties;
    @CFNullable
    private Integer reconsumeTimes;
    @CFNullable
    private Boolean unitMode;
    @CFNullable
    private Boolean batch;
    private Integer maxReconsumeTimes;

    @Override
    public void checkFields() throws RemotingCommandException {
    }

    public String getProducerGroup() {
        return this.producerGroup;
    }

    public void setProducerGroup(String producerGroup) {
        this.producerGroup = producerGroup;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getDefaultTopic() {
        return this.defaultTopic;
    }

    public void setDefaultTopic(String defaultTopic) {
        this.defaultTopic = defaultTopic;
    }

    public Integer getDefaultTopicQueueNums() {
        return this.defaultTopicQueueNums;
    }

    public void setDefaultTopicQueueNums(Integer defaultTopicQueueNums) {
        this.defaultTopicQueueNums = defaultTopicQueueNums;
    }

    @Override
    public Integer getQueueId() {
        return this.queueId;
    }

    @Override
    public void setQueueId(Integer queueId) {
        this.queueId = queueId;
    }

    public Integer getSysFlag() {
        return this.sysFlag;
    }

    public void setSysFlag(Integer sysFlag) {
        this.sysFlag = sysFlag;
    }

    public Long getBornTimestamp() {
        return this.bornTimestamp;
    }

    public void setBornTimestamp(Long bornTimestamp) {
        this.bornTimestamp = bornTimestamp;
    }

    public Integer getFlag() {
        return this.flag;
    }

    public void setFlag(Integer flag) {
        this.flag = flag;
    }

    public String getProperties() {
        return this.properties;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public Integer getReconsumeTimes() {
        if (null == this.reconsumeTimes) {
            return 0;
        }
        return this.reconsumeTimes;
    }

    public void setReconsumeTimes(Integer reconsumeTimes) {
        this.reconsumeTimes = reconsumeTimes;
    }

    public boolean isUnitMode() {
        if (null == this.unitMode) {
            return false;
        }
        return this.unitMode;
    }

    public void setUnitMode(Boolean isUnitMode) {
        this.unitMode = isUnitMode;
    }

    public Integer getMaxReconsumeTimes() {
        return this.maxReconsumeTimes;
    }

    public void setMaxReconsumeTimes(Integer maxReconsumeTimes) {
        this.maxReconsumeTimes = maxReconsumeTimes;
    }

    public boolean isBatch() {
        if (null == this.batch) {
            return false;
        }
        return this.batch;
    }

    public void setBatch(Boolean batch) {
        this.batch = batch;
    }

    public static SendMessageRequestHeader parseRequestHeader(RemotingCommand request) throws RemotingCommandException {
        SendMessageRequestHeaderV2 requestHeaderV2 = null;
        SendMessageRequestHeader requestHeader = null;
        switch (request.getCode()) {
            case 310: 
            case 320: {
                requestHeaderV2 = request.decodeCommandCustomHeader(SendMessageRequestHeaderV2.class);
            }
            case 10: {
                requestHeader = null == requestHeaderV2 ? request.decodeCommandCustomHeader(SendMessageRequestHeader.class) : SendMessageRequestHeaderV2.createSendMessageRequestHeaderV1(requestHeaderV2);
            }
        }
        return requestHeader;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("producerGroup", (Object)this.producerGroup).add("topic", (Object)this.topic).add("defaultTopic", (Object)this.defaultTopic).add("defaultTopicQueueNums", (Object)this.defaultTopicQueueNums).add("queueId", (Object)this.queueId).add("sysFlag", (Object)this.sysFlag).add("bornTimestamp", (Object)this.bornTimestamp).add("flag", (Object)this.flag).add("properties", (Object)this.properties).add("reconsumeTimes", (Object)this.reconsumeTimes).add("unitMode", (Object)this.unitMode).add("batch", (Object)this.batch).add("maxReconsumeTimes", (Object)this.maxReconsumeTimes).toString();
    }
}

