/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore;

import io.opentelemetry.api.common.Attributes;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.CommitLogDispatcher;
import org.apache.rocketmq.store.ConsumeQueue;
import org.apache.rocketmq.store.DispatchRequest;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.store.SelectMappedBufferResult;
import org.apache.rocketmq.tieredstore.common.AppendResult;
import org.apache.rocketmq.tieredstore.common.TieredMessageStoreConfig;
import org.apache.rocketmq.tieredstore.common.TieredStoreExecutor;
import org.apache.rocketmq.tieredstore.container.TieredContainerManager;
import org.apache.rocketmq.tieredstore.container.TieredMessageQueueContainer;
import org.apache.rocketmq.tieredstore.metrics.TieredStoreMetricsManager;
import org.apache.rocketmq.tieredstore.provider.TieredFileSegment;
import org.apache.rocketmq.tieredstore.util.CQItemBufferUtil;
import org.apache.rocketmq.tieredstore.util.MessageBufferUtil;
import org.apache.rocketmq.tieredstore.util.TieredStoreUtil;

public class TieredDispatcher
extends ServiceThread
implements CommitLogDispatcher {
    private static final Logger logger = LoggerFactory.getLogger((String)"RocketmqTieredStore");
    private final MessageStore defaultStore;
    private final TieredContainerManager tieredContainerManager;
    private final TieredMessageStoreConfig storeConfig;
    private final String brokerName;
    private ConcurrentMap<TieredMessageQueueContainer, List<DispatchRequest>> dispatchRequestReadMap;
    private ConcurrentMap<TieredMessageQueueContainer, List<DispatchRequest>> dispatchRequestWriteMap;
    private final ReentrantLock dispatchRequestListLock;

    public TieredDispatcher(MessageStore defaultStore, TieredMessageStoreConfig storeConfig) {
        this.defaultStore = defaultStore;
        this.storeConfig = storeConfig;
        this.brokerName = storeConfig.getBrokerName();
        this.tieredContainerManager = TieredContainerManager.getInstance(storeConfig);
        this.dispatchRequestReadMap = new ConcurrentHashMap<TieredMessageQueueContainer, List<DispatchRequest>>();
        this.dispatchRequestWriteMap = new ConcurrentHashMap<TieredMessageQueueContainer, List<DispatchRequest>>();
        this.dispatchRequestListLock = new ReentrantLock();
        TieredStoreExecutor.commonScheduledExecutor.scheduleWithFixedDelay(() -> {
            try {
                for (TieredMessageQueueContainer container : this.tieredContainerManager.getAllMQContainer()) {
                    if (container.getQueueLock().isLocked()) continue;
                    TieredStoreExecutor.dispatchExecutor.execute(() -> {
                        try {
                            this.dispatchByMQContainer(container);
                        }
                        catch (Throwable throwable) {
                            logger.error("[Bug]dispatch failed, can not dispatch by container: topic: {}, queueId: {}", new Object[]{container.getMessageQueue().getTopic(), container.getMessageQueue().getQueueId(), throwable});
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }, 30L, 10L, TimeUnit.SECONDS);
        TieredStoreExecutor.commonScheduledExecutor.scheduleWithFixedDelay(() -> {
            try {
                for (TieredMessageQueueContainer container : this.tieredContainerManager.getAllMQContainer()) {
                    container.flushMetadata();
                }
            }
            catch (Throwable e) {
                logger.error("dispatch by queue container failed: ", e);
            }
        }, 30L, 10L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dispatch(DispatchRequest request) {
        if (this.stopped) {
            return;
        }
        String topic = request.getTopic();
        if (TieredStoreUtil.isSystemTopic(topic)) {
            return;
        }
        TieredMessageQueueContainer container = this.tieredContainerManager.getOrCreateMQContainer(new MessageQueue(topic, this.brokerName, request.getQueueId()));
        if (container == null) {
            logger.error("[Bug]TieredDispatcher#dispatch: dispatch failed, can not create container: topic: {}, queueId: {}", (Object)request.getTopic(), (Object)request.getQueueId());
            return;
        }
        if (this.dispatchRequestWriteMap.getOrDefault(container, Collections.emptyList()).size() > this.storeConfig.getTieredStoreMaxGroupCommitCount() || this.dispatchRequestReadMap.getOrDefault(container, Collections.emptyList()).size() > this.storeConfig.getTieredStoreMaxGroupCommitCount()) {
            return;
        }
        if (container.getDispatchOffset() == -1L) {
            container.initOffset(request.getConsumeQueueOffset());
        }
        if (request.getConsumeQueueOffset() == container.getDispatchOffset()) {
            try {
                if (container.getQueueLock().isLocked() || !container.getQueueLock().tryLock(1L, TimeUnit.MILLISECONDS)) {
                    return;
                }
            }
            catch (Exception e) {
                logger.warn("TieredDispatcher#dispatch: dispatch failed, can not get container lock: topic: {}, queueId: {}", new Object[]{request.getTopic(), request.getQueueId(), e});
                if (!container.getQueueLock().isLocked()) return;
                container.getQueueLock().unlock();
                return;
            }
            if (request.getConsumeQueueOffset() != container.getDispatchOffset()) {
                container.getQueueLock().unlock();
                return;
            }
            SelectMappedBufferResult message = this.defaultStore.selectOneMessageByOffset(request.getCommitLogOffset(), request.getMsgSize());
            if (message == null) {
                logger.error("TieredDispatcher#dispatch: dispatch failed, can not get message from next store: topic: {}, queueId: {}, commitLog offset: {}, size: {}", new Object[]{request.getTopic(), request.getQueueId(), request.getCommitLogOffset(), request.getMsgSize()});
                container.getQueueLock().unlock();
                return;
            }
            try {
                if (request.getConsumeQueueOffset() < container.getDispatchOffset()) {
                    return;
                }
                AppendResult result = container.appendCommitLog(message.getByteBuffer());
                long newCommitLogOffset = container.getCommitLogMaxOffset() - (long)message.getByteBuffer().remaining();
                this.handleAppendCommitLogResult(result, container, request.getConsumeQueueOffset(), container.getDispatchOffset(), newCommitLogOffset, request.getMsgSize(), request.getTagsCode(), message.getByteBuffer());
                if (result != AppendResult.SUCCESS) return;
                Attributes attributes = TieredStoreMetricsManager.newAttributesBuilder().put("topic", request.getTopic()).put("queue_id", (long)request.getQueueId()).put("file_type", TieredFileSegment.FileSegmentType.COMMIT_LOG.name().toLowerCase()).build();
                TieredStoreMetricsManager.messagesDispatchTotal.add(1L, attributes);
                return;
            }
            catch (Exception throwable) {
                logger.error("TieredDispatcher#dispatch: dispatch failed: topic: {}, queueId: {}, queue offset: {}", new Object[]{request.getTopic(), request.getQueueId(), request.getConsumeQueueOffset(), throwable});
                return;
            }
            finally {
                message.release();
                container.getQueueLock().unlock();
            }
        }
        if (container.getQueueLock().isLocked()) return;
        try {
            TieredStoreExecutor.dispatchExecutor.execute(() -> {
                try {
                    this.dispatchByMQContainer(container);
                }
                catch (Throwable throwable) {
                    logger.error("[Bug]TieredDispatcher#dispatchByMQContainer: dispatch failed, can not dispatch by container: topic: {}, queueId: {}", new Object[]{topic, container.getMessageQueue().getQueueId(), throwable});
                }
            });
            return;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchByMQContainer(TieredMessageQueueContainer container) {
        if (this.stopped) {
            return;
        }
        if (container.getDispatchOffset() == -1L) {
            return;
        }
        if (this.dispatchRequestWriteMap.getOrDefault(container, Collections.emptyList()).size() > this.storeConfig.getTieredStoreMaxGroupCommitCount() || this.dispatchRequestReadMap.getOrDefault(container, Collections.emptyList()).size() > this.storeConfig.getTieredStoreMaxGroupCommitCount()) {
            return;
        }
        MessageQueue mq = container.getMessageQueue();
        String topic = mq.getTopic();
        int queueId = mq.getQueueId();
        long beforeOffset = container.getDispatchOffset();
        long minOffsetInQueue = this.defaultStore.getMinOffsetInQueue(topic, queueId);
        long maxOffsetInQueue = this.defaultStore.getMaxOffsetInQueue(topic, queueId);
        if (beforeOffset >= maxOffsetInQueue) {
            return;
        }
        try {
            if (!container.getQueueLock().tryLock(200L, TimeUnit.MILLISECONDS)) {
                return;
            }
        }
        catch (Exception e) {
            logger.warn("TieredDispatcher#dispatchByMQContainer: dispatch failed, can not get container lock: topic: {}, queueId: {}", new Object[]{mq.getTopic(), mq.getQueueId(), e});
            if (container.getQueueLock().isLocked()) {
                container.getQueueLock().unlock();
            }
            return;
        }
        try {
            long queueOffset = container.getDispatchOffset();
            if (minOffsetInQueue > queueOffset) {
                logger.warn("BlobDispatcher#dispatchByMQContainer: message that needs to be dispatched does not exist: topic: {}, queueId: {}, message queue offset: {}, min queue offset: {}", new Object[]{topic, queueId, queueOffset, minOffsetInQueue});
                container.initOffset(minOffsetInQueue);
                queueOffset = minOffsetInQueue;
            }
            beforeOffset = queueOffset;
            long limit = Math.min(queueOffset + 100000L, maxOffsetInQueue);
            ConsumeQueue consumeQueue = (ConsumeQueue)this.defaultStore.getConsumeQueue(topic, queueId);
            while (queueOffset < limit) {
                SelectMappedBufferResult cqItem = consumeQueue.getIndexBuffer(queueOffset);
                if (cqItem == null) {
                    logger.error("[Bug]TieredDispatcher#dispatchByMQContainer: dispatch failed, can not get cq item: topic: {}, queueId: {}, offset: {}", new Object[]{topic, queueId, queueOffset});
                    return;
                }
                long commitLogOffset = CQItemBufferUtil.getCommitLogOffset(cqItem.getByteBuffer());
                int size = CQItemBufferUtil.getSize(cqItem.getByteBuffer());
                long tagCode = CQItemBufferUtil.getTagCode(cqItem.getByteBuffer());
                cqItem.release();
                SelectMappedBufferResult message = this.defaultStore.selectOneMessageByOffset(commitLogOffset, size);
                if (message == null) {
                    logger.error("TieredDispatcher#dispatchByMQContainer: dispatch failed, can not get message from next store: topic: {}, queueId: {}, commitLog offset: {}, size: {}", new Object[]{topic, queueId, commitLogOffset, size});
                    break;
                }
                AppendResult result = container.appendCommitLog(message.getByteBuffer(), true);
                long newCommitLogOffset = container.getCommitLogMaxOffset() - (long)message.getByteBuffer().remaining();
                this.handleAppendCommitLogResult(result, container, queueOffset, container.getDispatchOffset(), newCommitLogOffset, size, tagCode, message.getByteBuffer());
                message.release();
                if (result != AppendResult.SUCCESS) {
                    --queueOffset;
                    break;
                }
                ++queueOffset;
            }
            Attributes attributes = TieredStoreMetricsManager.newAttributesBuilder().put("topic", mq.getTopic()).put("queue_id", (long)mq.getQueueId()).put("file_type", TieredFileSegment.FileSegmentType.COMMIT_LOG.name().toLowerCase()).build();
            TieredStoreMetricsManager.messagesDispatchTotal.add(queueOffset - beforeOffset, attributes);
        }
        finally {
            container.getQueueLock().unlock();
        }
        if (container.getDispatchOffset() < maxOffsetInQueue && !container.getQueueLock().isLocked()) {
            TieredStoreExecutor.dispatchExecutor.execute(() -> {
                try {
                    this.dispatchByMQContainer(container);
                }
                catch (Throwable throwable) {
                    logger.error("[Bug]TieredDispatcher#dispatchByMQContainer: dispatch failed, can not dispatch by container: topic: {}, queueId: {}", new Object[]{topic, queueId, throwable});
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAppendCommitLogResult(AppendResult result, TieredMessageQueueContainer container, long queueOffset, long dispatchOffset, long newCommitLogOffset, int size, long tagCode, ByteBuffer message) {
        MessageQueue mq = container.getMessageQueue();
        String topic = mq.getTopic();
        int queueId = mq.getQueueId();
        switch (result) {
            case SUCCESS: {
                break;
            }
            case OFFSET_INCORRECT: {
                long offset = MessageBufferUtil.getQueueOffset(message);
                if (queueOffset != offset) {
                    logger.error("[Bug]queue offset: {} is not equal to queue offset in message: {}", (Object)queueOffset, (Object)offset);
                }
                logger.error("[Bug]append message failed, offset is incorrect, maybe because of race: topic: {}, queueId: {}, queue offset: {}, dispatchOffset: {}", new Object[]{topic, queueId, queueOffset, dispatchOffset});
                return;
            }
            case BUFFER_FULL: {
                logger.debug("append message failed: topic: {}, queueId: {}, queue offset: {}, result: {}", new Object[]{topic, queueId, queueOffset, result});
                return;
            }
            default: {
                logger.info("append message failed: topic: {}, queueId: {}, queue offset: {}, result: {}", new Object[]{topic, queueId, queueOffset, result});
                return;
            }
        }
        this.dispatchRequestListLock.lock();
        try {
            Map<String, String> properties = MessageBufferUtil.getProperties(message);
            DispatchRequest dispatchRequest = new DispatchRequest(topic, queueId, newCommitLogOffset, size, tagCode, MessageBufferUtil.getStoreTimeStamp(message), queueOffset, properties.getOrDefault("KEYS", ""), properties.getOrDefault("UNIQ_KEY", ""), 0, 0L, new HashMap());
            dispatchRequest.setOffsetId(MessageBufferUtil.getOffsetId(message));
            List requestList = this.dispatchRequestWriteMap.computeIfAbsent(container, k -> new ArrayList());
            requestList.add(dispatchRequest);
            if (((DispatchRequest)requestList.get(0)).getConsumeQueueOffset() >= container.getBuildCQMaxOffset()) {
                this.wakeup();
            }
        }
        finally {
            this.dispatchRequestListLock.unlock();
        }
    }

    public void swapDispatchRequestList() {
        this.dispatchRequestListLock.lock();
        try {
            this.dispatchRequestReadMap = this.dispatchRequestWriteMap;
            this.dispatchRequestWriteMap = new ConcurrentHashMap<TieredMessageQueueContainer, List<DispatchRequest>>();
        }
        finally {
            this.dispatchRequestListLock.unlock();
        }
    }

    public void sendBackDispatchRequestList() {
        if (!this.dispatchRequestReadMap.isEmpty()) {
            this.dispatchRequestListLock.lock();
            try {
                this.dispatchRequestReadMap.forEach((container, requestList) -> {
                    if (requestList.isEmpty()) {
                        logger.warn("[Bug]TieredDispatcher#sendBackDispatchRequestList: requestList is empty, no need to send back: topic: {}, queueId: {}", (Object)container.getMessageQueue().getTopic(), (Object)container.getMessageQueue().getQueueId());
                        return;
                    }
                    List requestListToWrite = this.dispatchRequestWriteMap.computeIfAbsent((TieredMessageQueueContainer)container, k -> new ArrayList());
                    if (!requestListToWrite.isEmpty() && ((DispatchRequest)requestList.get(requestList.size() - 1)).getConsumeQueueOffset() > ((DispatchRequest)requestListToWrite.get(0)).getConsumeQueueOffset()) {
                        logger.warn("[Bug]TieredDispatcher#sendBackDispatchRequestList: dispatch request list is not continuous: topic: {}, queueId: {}, last list max offset: {}, new list min offset: {}", new Object[]{container.getMessageQueue().getTopic(), container.getMessageQueue().getQueueId(), ((DispatchRequest)requestList.get(requestList.size() - 1)).getConsumeQueueOffset(), ((DispatchRequest)requestListToWrite.get(0)).getConsumeQueueOffset()});
                        requestList.sort(Comparator.comparingLong(DispatchRequest::getConsumeQueueOffset));
                    }
                    requestList.addAll(requestListToWrite);
                    this.dispatchRequestWriteMap.put((TieredMessageQueueContainer)container, (List<DispatchRequest>)requestList);
                });
                this.dispatchRequestReadMap = new ConcurrentHashMap<TieredMessageQueueContainer, List<DispatchRequest>>();
            }
            finally {
                this.dispatchRequestListLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildCQAndIndexFile() {
        this.swapDispatchRequestList();
        HashMap<MessageQueue, Long> cqMetricsMap = new HashMap<MessageQueue, Long>();
        HashMap<MessageQueue, Long> ifMetricsMap = new HashMap<MessageQueue, Long>();
        for (Map.Entry entry : this.dispatchRequestReadMap.entrySet()) {
            TieredMessageQueueContainer container = (TieredMessageQueueContainer)entry.getKey();
            List requestList = (List)entry.getValue();
            if (container.isClosed()) {
                requestList.clear();
            }
            MessageQueue messageQueue2 = container.getMessageQueue();
            Iterator iterator = requestList.iterator();
            block7: while (iterator.hasNext()) {
                Long count2;
                DispatchRequest request = (DispatchRequest)iterator.next();
                if (request.getConsumeQueueOffset() < container.getConsumeQueueMaxOffset()) {
                    iterator.remove();
                    continue;
                }
                if (container.getBuildCQMaxOffset() < request.getConsumeQueueOffset()) break;
                AppendResult result = container.appendConsumeQueue(request, true);
                if (result == AppendResult.SUCCESS) {
                    count2 = cqMetricsMap.computeIfAbsent(messageQueue2, key -> 0L);
                    cqMetricsMap.put(messageQueue2, count2 + 1L);
                } else {
                    if (result == AppendResult.OFFSET_INCORRECT) {
                        logger.error("build consumeQueue and indexFile failed, offset is messed up, try to rebuild cq: topic: {}, queue: {}, queue offset: {}, max queue offset: {}", new Object[]{request.getTopic(), request.getQueueId(), request.getConsumeQueueOffset(), container.getConsumeQueueMaxOffset()});
                        container.getQueueLock().lock();
                        try {
                            container.initOffset(container.getConsumeQueueMaxOffset());
                            this.dispatchRequestWriteMap.remove(container);
                            requestList.clear();
                            break;
                        }
                        finally {
                            container.getQueueLock().unlock();
                        }
                    }
                    logger.warn("build consumeQueue failed, result: {}, topic: {}, queue: {}, queue offset: {}", new Object[]{result, request.getTopic(), request.getQueueId(), request.getConsumeQueueOffset()});
                }
                if (!this.storeConfig.isMessageIndexEnable() || result != AppendResult.SUCCESS) continue;
                result = container.appendIndexFile(request);
                switch (result) {
                    case SUCCESS: {
                        count2 = ifMetricsMap.computeIfAbsent(messageQueue2, key -> 0L);
                        ifMetricsMap.put(messageQueue2, count2 + 1L);
                        iterator.remove();
                        continue block7;
                    }
                }
                logger.warn("build indexFile failed, result: {}, topic: {}, queue: {}, queue offset: {}", new Object[]{result, request.getTopic(), request.getQueueId(), request.getConsumeQueueOffset()});
            }
            if (!requestList.isEmpty()) continue;
            this.dispatchRequestReadMap.remove(container);
        }
        cqMetricsMap.forEach((messageQueue, count) -> {
            Attributes attributes = TieredStoreMetricsManager.newAttributesBuilder().put("topic", messageQueue.getTopic()).put("queue_id", (long)messageQueue.getQueueId()).put("file_type", TieredFileSegment.FileSegmentType.CONSUME_QUEUE.name().toLowerCase()).build();
            TieredStoreMetricsManager.messagesDispatchTotal.add(count.longValue(), attributes);
        });
        ifMetricsMap.forEach((messageQueue, count) -> {
            Attributes attributes = TieredStoreMetricsManager.newAttributesBuilder().put("topic", messageQueue.getTopic()).put("queue_id", (long)messageQueue.getQueueId()).put("file_type", TieredFileSegment.FileSegmentType.INDEX.name().toLowerCase()).build();
            TieredStoreMetricsManager.messagesDispatchTotal.add(count.longValue(), attributes);
        });
        this.sendBackDispatchRequestList();
    }

    public String getServiceName() {
        return "TieredStoreDispatcherService";
    }

    public void run() {
        while (!this.stopped) {
            this.waitForRunning(1000L);
            try {
                this.buildCQAndIndexFile();
            }
            catch (Exception e) {
                logger.error("build consumeQueue and indexFile failed: ", (Throwable)e);
            }
        }
    }
}

