/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.example.rpc;

import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.RequestCallback;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;

public class AsyncRequestProducer {
    private static final Logger log = LoggerFactory.getLogger(AsyncRequestProducer.class);

    public static void main(String[] args) throws MQClientException, InterruptedException {
        String producerGroup = "please_rename_unique_group_name";
        final String topic = "RequestTopic";
        long ttl = 3000L;
        DefaultMQProducer producer = new DefaultMQProducer(producerGroup);
        producer.start();
        try {
            Message msg = new Message(topic, "", "Hello world".getBytes("UTF-8"));
            final long begin = System.currentTimeMillis();
            producer.request(msg, new RequestCallback(){

                public void onSuccess(Message message) {
                    long cost = System.currentTimeMillis() - begin;
                    System.out.printf("request to <%s> cost: %d replyMessage: %s %n", topic, cost, message);
                }

                public void onException(Throwable e) {
                    System.err.printf("request to <%s> fail.", topic);
                }
            }, ttl);
        }
        catch (Exception e) {
            log.warn("", (Throwable)e);
        }
    }
}

