/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.query;

import java.util.List;
import java.util.Objects;
import org.apache.qpid.server.query.engine.evaluator.DateFormat;
import org.apache.qpid.server.query.engine.evaluator.settings.QuerySettings;
import org.apache.qpid.server.query.engine.parsing.converter.DateTimeConverter;
import org.apache.qpid.server.query.engine.parsing.converter.NumberConverter;
import org.apache.qpid.server.query.engine.parsing.expression.AbstractExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.Expression;
import org.apache.qpid.server.query.engine.parsing.expression.ExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.function.aggregation.AbstractAggregationExpression;
import org.apache.qpid.server.query.engine.parsing.query.SelectExpression;

public class ProjectionExpression<T, R>
extends AbstractExpressionNode<T, R> {
    protected final int _ordinal;

    public ProjectionExpression(String alias, ExpressionNode<T, R> expression, int ordinal) {
        super(alias, expression);
        this._ordinal = ordinal;
    }

    @Override
    public R apply(T object) {
        QuerySettings querySettings;
        DateFormat dateFormat;
        Object result = this.evaluateChild(0, object);
        if (DateTimeConverter.isDateTime(result) && (dateFormat = (querySettings = (QuerySettings)this.ctx().get("query.settings")).getDateTimeFormat()).equals((Object)DateFormat.LONG)) {
            return (R)DateTimeConverter.toLong(result);
        }
        return (R)result;
    }

    public R applyAggregation(SelectExpression<T, R> selectExpression, List<T> items) {
        List aggregations = this.getAggregations();
        for (AbstractAggregationExpression aggregation : aggregations) {
            Object result = aggregation.aggregate(items);
            aggregation.setValue(result);
            aggregation.setSelect(selectExpression);
        }
        return this.apply(null);
    }

    public Expression<T, R> getExpression() {
        return this.getChild(0);
    }

    @Override
    public void setAlias(String alias) {
        this._metadata.setAlias(alias);
    }

    @Override
    public String getAlias() {
        return this._metadata.getAlias() != null ? this._metadata.getAlias() : this.getChild(0).getAlias();
    }

    public boolean isOrdinal() {
        return NumberConverter.isNumber(this.getAlias());
    }

    @Override
    public String toString() {
        ExpressionNode expression = this.getChild(0);
        return Objects.equals(expression.getAlias(), this.getAlias()) ? expression.getAlias() : expression.getAlias() + " as " + this.getAlias();
    }
}

