/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.elab;

import net.sf.saxon.Controller;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.SequenceCollector;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.elab.BooleanEvaluator;
import net.sf.saxon.expr.elab.EagerPushEvaluator;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.OptionalItemEvaluator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.elab.SequenceEvaluator;
import net.sf.saxon.expr.elab.UnicodeStringEvaluator;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.value.Cardinality;

public abstract class PushElaborator
extends Elaborator {
    @Override
    public PullEvaluator elaborateForPull() {
        Expression expr = this.getExpression();
        if (Cardinality.allowsMany(expr.getCardinality())) {
            PushEvaluator pushEval = this.elaborateForPush();
            return context -> {
                Controller controller = context.getController();
                assert (controller != null);
                SequenceCollector seq = controller.allocateSequenceOutputter();
                TailCall tc = pushEval.processLeavingTail(new ComplexContentOutputter(seq), context);
                Expression.dispatchTailCall(tc);
                seq.close();
                return seq.iterate();
            };
        }
        ItemEvaluator itemEval = this.elaborateForItem();
        return context -> {
            Item item = itemEval.eval(context);
            return item == null ? EmptyIterator.getInstance() : SingletonIterator.makeIterator(item);
        };
    }

    @Override
    public SequenceEvaluator eagerly() {
        Expression expr = this.getExpression();
        if (Cardinality.allowsMany(expr.getCardinality())) {
            PushEvaluator pushEval = this.elaborateForPush();
            return new EagerPushEvaluator(pushEval);
        }
        return new OptionalItemEvaluator(this.elaborateForItem());
    }

    @Override
    public PushEvaluator elaborateForPush() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ItemEvaluator elaborateForItem() {
        PushEvaluator pushEval = this.elaborateForPush();
        return context -> {
            Controller controller = context.getController();
            assert (controller != null);
            SequenceCollector seq = controller.allocateSequenceOutputter(1);
            TailCall tc = pushEval.processLeavingTail(new ComplexContentOutputter(seq), context);
            Expression.dispatchTailCall(tc);
            seq.close();
            return seq.getFirstItem();
        };
    }

    @Override
    public BooleanEvaluator elaborateForBoolean() {
        PullEvaluator pullEval = this.elaborateForPull();
        return context -> {
            SequenceIterator iter = pullEval.iterate(context);
            return ExpressionTool.effectiveBooleanValue(iter);
        };
    }

    @Override
    public UnicodeStringEvaluator elaborateForUnicodeString(boolean zeroLengthWhenAbsent) {
        ItemEvaluator ie = this.elaborateForItem();
        return context -> {
            Item item = ie.eval(context);
            return item == null ? this.handleNullUnicodeString(zeroLengthWhenAbsent) : item.getUnicodeStringValue();
        };
    }
}

