/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.iec608705104.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class ThreeOctetBinaryTime implements Message {

  // Properties.
  protected final int milliseconds;
  protected final boolean invalid;
  protected final byte minutes;

  public ThreeOctetBinaryTime(int milliseconds, boolean invalid, byte minutes) {
    super();
    this.milliseconds = milliseconds;
    this.invalid = invalid;
    this.minutes = minutes;
  }

  public int getMilliseconds() {
    return milliseconds;
  }

  public boolean getInvalid() {
    return invalid;
  }

  public byte getMinutes() {
    return minutes;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("ThreeOctetBinaryTime");

    // Simple Field (milliseconds)
    writeSimpleField(
        "milliseconds",
        milliseconds,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Simple Field (invalid)
    writeSimpleField(
        "invalid",
        invalid,
        writeBoolean(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        (byte) 0x00,
        writeUnsignedByte(writeBuffer, 1),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Simple Field (minutes)
    writeSimpleField(
        "minutes",
        minutes,
        writeUnsignedByte(writeBuffer, 6),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    writeBuffer.popContext("ThreeOctetBinaryTime");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    ThreeOctetBinaryTime _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (milliseconds)
    lengthInBits += 16;

    // Simple field (invalid)
    lengthInBits += 1;

    // Reserved Field (reserved)
    lengthInBits += 1;

    // Simple field (minutes)
    lengthInBits += 6;

    return lengthInBits;
  }

  public static ThreeOctetBinaryTime staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("ThreeOctetBinaryTime");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int milliseconds =
        readSimpleField(
            "milliseconds",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    boolean invalid =
        readSimpleField(
            "invalid", readBoolean(readBuffer), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    Byte reservedField0 =
        readReservedField(
            "reserved",
            readUnsignedByte(readBuffer, 1),
            (byte) 0x00,
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    byte minutes =
        readSimpleField(
            "minutes",
            readUnsignedByte(readBuffer, 6),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    readBuffer.closeContext("ThreeOctetBinaryTime");
    // Create the instance
    ThreeOctetBinaryTime _threeOctetBinaryTime;
    _threeOctetBinaryTime = new ThreeOctetBinaryTime(milliseconds, invalid, minutes);
    return _threeOctetBinaryTime;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ThreeOctetBinaryTime)) {
      return false;
    }
    ThreeOctetBinaryTime that = (ThreeOctetBinaryTime) o;
    return (getMilliseconds() == that.getMilliseconds())
        && (getInvalid() == that.getInvalid())
        && (getMinutes() == that.getMinutes())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getMilliseconds(), getInvalid(), getMinutes());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
