/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ImageGIF is the corresponding interface of ImageGIF
type ImageGIF interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsImageGIF is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsImageGIF()
	// CreateBuilder creates a ImageGIFBuilder
	CreateImageGIFBuilder() ImageGIFBuilder
}

// _ImageGIF is the data-structure of this message
type _ImageGIF struct {
}

var _ ImageGIF = (*_ImageGIF)(nil)

// NewImageGIF factory function for _ImageGIF
func NewImageGIF() *_ImageGIF {
	return &_ImageGIF{}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ImageGIFBuilder is a builder for ImageGIF
type ImageGIFBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() ImageGIFBuilder
	// Build builds the ImageGIF or returns an error if something is wrong
	Build() (ImageGIF, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ImageGIF
}

// NewImageGIFBuilder() creates a ImageGIFBuilder
func NewImageGIFBuilder() ImageGIFBuilder {
	return &_ImageGIFBuilder{_ImageGIF: new(_ImageGIF)}
}

type _ImageGIFBuilder struct {
	*_ImageGIF

	collectedErr []error
}

var _ (ImageGIFBuilder) = (*_ImageGIFBuilder)(nil)

func (b *_ImageGIFBuilder) WithMandatoryFields() ImageGIFBuilder {
	return b
}

func (b *_ImageGIFBuilder) Build() (ImageGIF, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._ImageGIF.deepCopy(), nil
}

func (b *_ImageGIFBuilder) MustBuild() ImageGIF {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ImageGIFBuilder) DeepCopy() any {
	_copy := b.CreateImageGIFBuilder().(*_ImageGIFBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateImageGIFBuilder creates a ImageGIFBuilder
func (b *_ImageGIF) CreateImageGIFBuilder() ImageGIFBuilder {
	if b == nil {
		return NewImageGIFBuilder()
	}
	return &_ImageGIFBuilder{_ImageGIF: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastImageGIF(structType any) ImageGIF {
	if casted, ok := structType.(ImageGIF); ok {
		return casted
	}
	if casted, ok := structType.(*ImageGIF); ok {
		return *casted
	}
	return nil
}

func (m *_ImageGIF) GetTypeName() string {
	return "ImageGIF"
}

func (m *_ImageGIF) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	return lengthInBits
}

func (m *_ImageGIF) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func ImageGIFParse(ctx context.Context, theBytes []byte) (ImageGIF, error) {
	return ImageGIFParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func ImageGIFParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (ImageGIF, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (ImageGIF, error) {
		return ImageGIFParseWithBuffer(ctx, readBuffer)
	}
}

func ImageGIFParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (ImageGIF, error) {
	v, err := (&_ImageGIF{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_ImageGIF) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__imageGIF ImageGIF, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ImageGIF"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ImageGIF")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("ImageGIF"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ImageGIF")
	}

	return m, nil
}

func (m *_ImageGIF) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ImageGIF) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("ImageGIF"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for ImageGIF")
	}

	if popErr := writeBuffer.PopContext("ImageGIF"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for ImageGIF")
	}
	return nil
}

func (m *_ImageGIF) IsImageGIF() {}

func (m *_ImageGIF) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ImageGIF) deepCopy() *_ImageGIF {
	if m == nil {
		return nil
	}
	_ImageGIFCopy := &_ImageGIF{}
	return _ImageGIFCopy
}

func (m *_ImageGIF) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
