/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.ext.proxy.context;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.olingo.client.api.domain.ClientLinkType;
import org.apache.olingo.ext.proxy.commons.EntityInvocationHandler;

public class EntityLinkDesc
implements Serializable {
    private static final long serialVersionUID = 704670372070370762L;
    private final String sourceName;
    private final EntityInvocationHandler source;
    private final Collection<EntityInvocationHandler> targets;
    private final ClientLinkType type;
    private final String reference;

    public EntityLinkDesc(String sourceName, EntityInvocationHandler source, Collection<EntityInvocationHandler> target, ClientLinkType type) {
        this.sourceName = sourceName;
        this.source = source;
        this.targets = target;
        this.type = type;
        this.reference = null;
    }

    public EntityLinkDesc(String sourceName, EntityInvocationHandler source, EntityInvocationHandler target, ClientLinkType type) {
        this.sourceName = sourceName;
        this.source = source;
        this.targets = Collections.singleton(target);
        this.type = type;
        this.reference = null;
    }

    public EntityLinkDesc(String sourceName, EntityInvocationHandler source, String targetRef) {
        this.sourceName = sourceName;
        this.source = source;
        this.targets = null;
        this.type = null;
        this.reference = targetRef;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public EntityInvocationHandler getSource() {
        return this.source;
    }

    public Collection<EntityInvocationHandler> getTargets() {
        return this.targets;
    }

    public ClientLinkType getType() {
        return this.type;
    }

    public String getReference() {
        return this.reference;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

