/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmTerm;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.TargetType;
import org.apache.olingo.commons.api.edm.geo.SRID;
import org.apache.olingo.commons.api.edm.provider.CsdlTerm;
import org.apache.olingo.commons.core.edm.AbstractEdmNamed;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;

public class EdmTermImpl
extends AbstractEdmNamed
implements EdmTerm {
    private final CsdlTerm term;
    private final FullQualifiedName fqn;
    private EdmType termType;
    private EdmTerm baseTerm;
    private List<TargetType> appliesTo;

    public EdmTermImpl(Edm edm, String namespace, CsdlTerm term) {
        super(edm, term.getName(), term);
        this.term = term;
        this.fqn = new FullQualifiedName(namespace, term.getName());
    }

    @Override
    public FullQualifiedName getFullQualifiedName() {
        return this.fqn;
    }

    @Override
    public EdmType getType() {
        if (this.termType == null) {
            if (this.term.getType() == null) {
                throw new EdmException("Terms must hava a full qualified type.");
            }
            this.termType = new EdmTypeInfo.Builder().setEdm(this.edm).setTypeExpression(this.term.getType()).build().getType();
            if (this.termType == null) {
                throw new EdmException("Cannot find type with name: " + this.term.getType());
            }
        }
        return this.termType;
    }

    @Override
    public EdmTerm getBaseTerm() {
        if (this.baseTerm == null && this.term.getBaseTerm() != null) {
            this.baseTerm = this.edm.getTerm(new FullQualifiedName(this.term.getBaseTerm()));
        }
        return this.baseTerm;
    }

    @Override
    public List<TargetType> getAppliesTo() {
        if (this.appliesTo == null) {
            ArrayList<TargetType> localAppliesTo = new ArrayList<TargetType>();
            for (String apply : this.term.getAppliesTo()) {
                try {
                    localAppliesTo.add(TargetType.valueOf(apply));
                }
                catch (IllegalArgumentException e) {
                    throw new EdmException("Invalid AppliesTo value: " + apply, e);
                }
            }
            this.appliesTo = Collections.unmodifiableList(localAppliesTo);
        }
        return this.appliesTo;
    }

    @Override
    public boolean isNullable() {
        return this.term.isNullable();
    }

    @Override
    public Integer getMaxLength() {
        return this.term.getMaxLength();
    }

    @Override
    public Integer getPrecision() {
        return this.term.getPrecision();
    }

    @Override
    public Integer getScale() {
        return this.term.getScale();
    }

    @Override
    public SRID getSrid() {
        return this.term.getSrid();
    }

    @Override
    public String getDefaultValue() {
        return this.term.getDefaultValue();
    }
}

