/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.dom;

import com.fasterxml.aalto.dom.BijectiveNsMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import org.apache.olingo.javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.ri.EmptyIterator;

public abstract class OutputElementBase
implements NamespaceContext {
    public static final int PREFIX_UNBOUND = 0;
    public static final int PREFIX_OK = 1;
    public static final int PREFIX_MISBOUND = 2;
    protected NamespaceContext _rootNsContext;
    protected String _defaultNsURI;
    protected BijectiveNsMap _nsMapping;
    protected boolean _nsMapShared;

    protected OutputElementBase() {
        this._nsMapping = null;
        this._nsMapShared = false;
        this._defaultNsURI = "";
        this._rootNsContext = null;
    }

    protected OutputElementBase(OutputElementBase parent, BijectiveNsMap ns) {
        this._nsMapping = ns;
        this._nsMapShared = ns != null;
        this._defaultNsURI = parent._defaultNsURI;
        this._rootNsContext = parent._rootNsContext;
    }

    protected void relink(OutputElementBase parent) {
        this._nsMapping = parent._nsMapping;
        this._nsMapShared = this._nsMapping != null;
        this._defaultNsURI = parent._defaultNsURI;
        this._rootNsContext = parent._rootNsContext;
    }

    protected abstract void setRootNsContext(NamespaceContext var1);

    public abstract boolean isRoot();

    public abstract String getNameDesc();

    public final String getDefaultNsUri() {
        return this._defaultNsURI;
    }

    public final String getExplicitPrefix(String uri) {
        String prefix;
        if (this._nsMapping != null && (prefix = this._nsMapping.findPrefixByUri(uri)) != null) {
            return prefix;
        }
        if (this._rootNsContext != null && (prefix = this._rootNsContext.getPrefix(uri)) != null && prefix.length() > 0) {
            return prefix;
        }
        return null;
    }

    public final int isPrefixValid(String prefix, String nsURI, boolean isElement) throws XMLStreamException {
        if (nsURI == null) {
            nsURI = "";
        }
        if (prefix == null || prefix.length() == 0) {
            if (isElement ? nsURI == this._defaultNsURI || nsURI.equals(this._defaultNsURI) : nsURI.length() == 0) {
                return 1;
            }
            return 2;
        }
        if ("xml".equals(prefix)) {
            if (!nsURI.equals("http://www.w3.org/XML/1998/namespace")) {
                this.throwOutputError("Namespace prefix 'xml' can not be bound to non-default namespace ('" + nsURI + "'); has to be the default '" + "http://www.w3.org/XML/1998/namespace" + "'");
            }
            return 1;
        }
        String act = this._nsMapping != null ? this._nsMapping.findUriByPrefix(prefix) : null;
        if (act == null && this._rootNsContext != null) {
            act = this._rootNsContext.getNamespaceURI(prefix);
        }
        if (act == null) {
            return 0;
        }
        return act == nsURI || act.equals(nsURI) ? 1 : 2;
    }

    public abstract void setDefaultNsUri(String var1);

    public final String generateMapping(String prefixBase, String uri, int[] seqArr) {
        if (this._nsMapping == null) {
            this._nsMapping = BijectiveNsMap.createEmpty();
        } else if (this._nsMapShared) {
            this._nsMapping = this._nsMapping.createChild();
            this._nsMapShared = false;
        }
        return this._nsMapping.addGeneratedMapping(prefixBase, this._rootNsContext, uri, seqArr);
    }

    public final void addPrefix(String prefix, String uri) {
        if (this._nsMapping == null) {
            this._nsMapping = BijectiveNsMap.createEmpty();
        } else if (this._nsMapShared) {
            this._nsMapping = this._nsMapping.createChild();
            this._nsMapShared = false;
        }
        this._nsMapping.addMapping(prefix, uri);
    }

    @Override
    public final String getNamespaceURI(String prefix) {
        String uri;
        if (prefix.length() == 0) {
            return this._defaultNsURI;
        }
        if (this._nsMapping != null && (uri = this._nsMapping.findUriByPrefix(prefix)) != null) {
            return uri;
        }
        return this._rootNsContext != null ? this._rootNsContext.getNamespaceURI(prefix) : null;
    }

    @Override
    public final String getPrefix(String uri) {
        String prefix;
        if (this._defaultNsURI.equals(uri)) {
            return "";
        }
        if (this._nsMapping != null && (prefix = this._nsMapping.findPrefixByUri(uri)) != null) {
            return prefix;
        }
        return this._rootNsContext != null ? this._rootNsContext.getPrefix(uri) : null;
    }

    @Override
    public final Iterator<String> getPrefixes(String uri) {
        List<String> l = null;
        if (this._defaultNsURI.equals(uri)) {
            l = new ArrayList<String>();
            l.add("");
        }
        if (this._nsMapping != null) {
            l = this._nsMapping.getPrefixesBoundToUri(uri, l);
        }
        if (this._rootNsContext != null) {
            Iterator<String> it = this._rootNsContext.getPrefixes(uri);
            while (it.hasNext()) {
                String prefix = it.next();
                if (prefix.length() == 0) continue;
                if (l == null) {
                    l = new ArrayList();
                } else if (l.contains(prefix)) continue;
                l.add(prefix);
            }
        }
        if (l == null) {
            return EmptyIterator.getInstance();
        }
        return l.iterator();
    }

    protected final void throwOutputError(String msg) throws XMLStreamException {
        throw new XMLStreamException(msg);
    }
}

