/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.processor;

import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.odata2.api.ODataService;
import org.apache.olingo.odata2.api.edm.Edm;
import org.apache.olingo.odata2.api.edm.provider.EdmProvider;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.exception.ODataNotImplementedException;
import org.apache.olingo.odata2.api.processor.ODataProcessor;
import org.apache.olingo.odata2.api.processor.ODataSingleProcessor;
import org.apache.olingo.odata2.api.processor.feature.CustomContentType;
import org.apache.olingo.odata2.api.processor.part.BatchProcessor;
import org.apache.olingo.odata2.api.processor.part.EntityComplexPropertyProcessor;
import org.apache.olingo.odata2.api.processor.part.EntityLinkProcessor;
import org.apache.olingo.odata2.api.processor.part.EntityLinksProcessor;
import org.apache.olingo.odata2.api.processor.part.EntityMediaProcessor;
import org.apache.olingo.odata2.api.processor.part.EntityProcessor;
import org.apache.olingo.odata2.api.processor.part.EntitySetProcessor;
import org.apache.olingo.odata2.api.processor.part.EntitySimplePropertyProcessor;
import org.apache.olingo.odata2.api.processor.part.EntitySimplePropertyValueProcessor;
import org.apache.olingo.odata2.api.processor.part.FunctionImportProcessor;
import org.apache.olingo.odata2.api.processor.part.FunctionImportValueProcessor;
import org.apache.olingo.odata2.api.processor.part.MetadataProcessor;
import org.apache.olingo.odata2.api.processor.part.ServiceDocumentProcessor;
import org.apache.olingo.odata2.api.rt.RuntimeDelegate;

public class ODataSingleProcessorService
implements ODataService {
    private final ODataSingleProcessor processor;
    private final Edm edm;

    public ODataSingleProcessorService(EdmProvider provider, ODataSingleProcessor processor) {
        this.processor = processor;
        this.edm = RuntimeDelegate.createEdm((EdmProvider)provider);
    }

    public String getVersion() throws ODataException {
        return "2.0";
    }

    public Edm getEntityDataModel() throws ODataException {
        return this.edm;
    }

    public MetadataProcessor getMetadataProcessor() throws ODataException {
        return this.processor;
    }

    public ServiceDocumentProcessor getServiceDocumentProcessor() throws ODataException {
        return this.processor;
    }

    public EntityProcessor getEntityProcessor() throws ODataException {
        return this.processor;
    }

    public EntitySetProcessor getEntitySetProcessor() throws ODataException {
        return this.processor;
    }

    public EntityComplexPropertyProcessor getEntityComplexPropertyProcessor() throws ODataException {
        return this.processor;
    }

    public EntityLinkProcessor getEntityLinkProcessor() throws ODataException {
        return this.processor;
    }

    public EntityLinksProcessor getEntityLinksProcessor() throws ODataException {
        return this.processor;
    }

    public EntityMediaProcessor getEntityMediaProcessor() throws ODataException {
        return this.processor;
    }

    public EntitySimplePropertyProcessor getEntitySimplePropertyProcessor() throws ODataException {
        return this.processor;
    }

    public EntitySimplePropertyValueProcessor getEntitySimplePropertyValueProcessor() throws ODataException {
        return this.processor;
    }

    public FunctionImportProcessor getFunctionImportProcessor() throws ODataException {
        return this.processor;
    }

    public FunctionImportValueProcessor getFunctionImportValueProcessor() throws ODataException {
        return this.processor;
    }

    public BatchProcessor getBatchProcessor() throws ODataException {
        return this.processor;
    }

    public ODataProcessor getProcessor() throws ODataException {
        return this.processor;
    }

    public List<String> getSupportedContentTypes(Class<? extends ODataProcessor> processorFeature) throws ODataException {
        ArrayList<String> result = new ArrayList<String>();
        if (this.processor instanceof CustomContentType) {
            result.addAll(this.processor.getCustomContentTypes(processorFeature));
        }
        if (processorFeature == BatchProcessor.class) {
            result.add("*/*");
        } else if (processorFeature == EntityProcessor.class) {
            result.add("application/atom+xml;type=entry;charset=utf-8");
            result.add("application/atom+xml;charset=utf-8");
            result.add("application/json;charset=utf-8");
            result.add("application/json;charset=utf-8;odata=verbose");
            result.add("application/json");
            result.add("application/json;odata=verbose");
            result.add("application/xml;charset=utf-8");
        } else if (processorFeature == FunctionImportProcessor.class || processorFeature == EntityLinkProcessor.class || processorFeature == EntityLinksProcessor.class || processorFeature == EntitySimplePropertyProcessor.class || processorFeature == EntityComplexPropertyProcessor.class) {
            result.add("application/xml;charset=utf-8");
            result.add("application/json;charset=utf-8");
            result.add("application/json;charset=utf-8;odata=verbose");
            result.add("application/json");
            result.add("application/json;odata=verbose");
        } else if (processorFeature == EntityMediaProcessor.class || processorFeature == EntitySimplePropertyValueProcessor.class || processorFeature == FunctionImportValueProcessor.class) {
            result.add("*/*");
        } else if (processorFeature == EntitySetProcessor.class) {
            result.add("application/atom+xml;type=feed;charset=utf-8");
            result.add("application/atom+xml;charset=utf-8");
            result.add("application/json;charset=utf-8");
            result.add("application/json;charset=utf-8;odata=verbose");
            result.add("application/json");
            result.add("application/json;odata=verbose");
            result.add("application/xml;charset=utf-8");
        } else if (processorFeature == MetadataProcessor.class) {
            result.add("application/xml;charset=utf-8");
        } else if (processorFeature == ServiceDocumentProcessor.class) {
            result.add("application/atomsvc+xml;charset=utf-8");
            result.add("application/json;charset=utf-8");
            result.add("application/json;charset=utf-8;odata=verbose");
            result.add("application/json");
            result.add("application/json;odata=verbose");
            result.add("application/xml;charset=utf-8");
        } else {
            throw new ODataNotImplementedException();
        }
        return result;
    }
}

