/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.annotation.processor.core.datasource;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.odata2.annotation.processor.core.datasource.DataSource;
import org.apache.olingo.odata2.annotation.processor.core.datasource.DataStore;
import org.apache.olingo.odata2.annotation.processor.core.util.AnnotationHelper;
import org.apache.olingo.odata2.annotation.processor.core.util.AnnotationRuntimeException;
import org.apache.olingo.odata2.annotation.processor.core.util.ClassHelper;
import org.apache.olingo.odata2.api.annotation.edm.EdmMediaResourceContent;
import org.apache.olingo.odata2.api.annotation.edm.EdmMediaResourceMimeType;
import org.apache.olingo.odata2.api.annotation.edm.EdmNavigationProperty;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmFunctionImport;
import org.apache.olingo.odata2.api.edm.EdmMultiplicity;
import org.apache.olingo.odata2.api.exception.ODataApplicationException;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.exception.ODataNotFoundException;
import org.apache.olingo.odata2.api.exception.ODataNotImplementedException;

public class AnnotationInMemoryDs
implements DataSource {
    private static final AnnotationHelper ANNOTATION_HELPER = new AnnotationHelper();
    private final Map<String, DataStore<Object>> dataStores = new HashMap<String, DataStore<Object>>();
    private final boolean persistInMemory;

    public AnnotationInMemoryDs(Collection<Class<?>> annotatedClasses) throws ODataException {
        this(annotatedClasses, true);
    }

    public AnnotationInMemoryDs(Collection<Class<?>> annotatedClasses, boolean persistInMemory) throws ODataException {
        this.persistInMemory = persistInMemory;
        this.init(annotatedClasses);
    }

    public AnnotationInMemoryDs(String packageToScan) throws ODataException {
        this(packageToScan, true);
    }

    public AnnotationInMemoryDs(String packageToScan, boolean persistInMemory) throws ODataException {
        this.persistInMemory = persistInMemory;
        List<Class<?>> foundClasses = ClassHelper.loadClasses(packageToScan, new ClassHelper.ClassValidator(){

            @Override
            public boolean isClassValid(Class<?> c) {
                return null != c.getAnnotation(org.apache.olingo.odata2.api.annotation.edm.EdmEntitySet.class);
            }
        });
        this.init(foundClasses);
    }

    private void init(Collection<Class<?>> annotatedClasses) throws ODataException {
        try {
            for (Class<?> clz : annotatedClasses) {
                String entitySetName = ANNOTATION_HELPER.extractEntitySetName(clz);
                if (entitySetName != null) {
                    DataStore<?> dhs = DataStore.createInMemory(clz, this.persistInMemory);
                    this.dataStores.put(entitySetName, dhs);
                    continue;
                }
                if (ANNOTATION_HELPER.isEdmAnnotated(clz)) continue;
                throw new ODataException("Found not annotated class during DataStore initilization of type: " + clz.getName());
            }
        }
        catch (DataStore.DataStoreException e) {
            throw new ODataException("Error in DataStore initilization with message: " + e.getMessage(), (Throwable)((Object)e));
        }
    }

    public <T> DataStore<T> getDataStore(Class<T> clazz) {
        String entitySetName = ANNOTATION_HELPER.extractEntitySetName(clazz);
        return this.dataStores.get(entitySetName);
    }

    @Override
    public List<?> readData(EdmEntitySet entitySet) throws ODataNotImplementedException, ODataNotFoundException, EdmException, ODataApplicationException {
        DataStore<Object> holder = this.getDataStore(entitySet);
        if (holder != null) {
            return new ArrayList<Object>(holder.read());
        }
        throw new ODataNotFoundException(ODataNotFoundException.ENTITY);
    }

    @Override
    public Object readData(EdmEntitySet entitySet, Map<String, Object> keys) throws ODataNotFoundException, EdmException, ODataApplicationException {
        DataStore<Object> store = this.getDataStore(entitySet);
        if (store != null) {
            Object keyInstance = store.createInstance();
            ANNOTATION_HELPER.setKeyFields(keyInstance, keys);
            Object result = store.read(keyInstance);
            if (result != null) {
                return result;
            }
        }
        throw new ODataNotFoundException(ODataNotFoundException.ENTITY);
    }

    @Override
    public Object readData(EdmFunctionImport function, Map<String, Object> parameters, Map<String, Object> keys) throws ODataNotImplementedException, ODataNotFoundException, EdmException, ODataApplicationException {
        throw new ODataNotImplementedException(ODataNotImplementedException.COMMON);
    }

    @Override
    public Object readRelatedData(EdmEntitySet sourceEntitySet, Object sourceData, EdmEntitySet targetEntitySet, Map<String, Object> targetKeys) throws ODataNotImplementedException, ODataNotFoundException, EdmException, ODataApplicationException {
        DataStore<Object> sourceStore = this.dataStores.get(sourceEntitySet.getName());
        DataStore<Object> targetStore = this.dataStores.get(targetEntitySet.getName());
        AnnotationHelper.AnnotatedNavInfo navInfo = ANNOTATION_HELPER.getCommonNavigationInfo(sourceStore.getDataTypeClass(), targetStore.getDataTypeClass());
        Field sourceField = navInfo.isBiDirectional() ? navInfo.getToField() : navInfo.getFromField();
        if (sourceField == null) {
            throw new AnnotationRuntimeException("Missing source field for related data (sourceStore='" + sourceStore + "', targetStore='" + targetStore + "').");
        }
        List<Object> resultData = this.readResultData(targetStore, sourceData, sourceField);
        return this.extractResultData(targetStore, targetKeys, navInfo, resultData);
    }

    private List<Object> readResultData(DataStore<?> targetStore, Object sourceData, Field sourceField) throws DataStore.DataStoreException {
        Object navigationInstance = this.getValue(sourceField, sourceData);
        if (navigationInstance == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> resultData = new ArrayList<Object>();
        for (Object targetInstance : targetStore.read()) {
            if (navigationInstance instanceof Collection) {
                for (Object object : (Collection)navigationInstance) {
                    if (!targetStore.isKeyEqualChecked(targetInstance, object)) continue;
                    resultData.add(targetInstance);
                }
                continue;
            }
            if (!targetStore.isKeyEqualChecked(targetInstance, navigationInstance)) continue;
            resultData.add(targetInstance);
        }
        return resultData;
    }

    private Object extractResultData(DataStore<?> targetStore, Map<String, Object> targetKeys, AnnotationHelper.AnnotatedNavInfo navInfo, List<Object> resultData) throws DataStore.DataStoreException {
        if (navInfo.getToMultiplicity() == EdmMultiplicity.MANY) {
            if (targetKeys.isEmpty()) {
                return resultData;
            }
            Object keyInstance = targetStore.createInstance();
            ANNOTATION_HELPER.setKeyFields(keyInstance, targetKeys);
            for (Object result : resultData) {
                if (!targetStore.isKeyEqualChecked(result, keyInstance)) continue;
                return result;
            }
            return null;
        }
        if (resultData.isEmpty()) {
            return null;
        }
        return resultData.get(0);
    }

    @Override
    public DataSource.BinaryData readBinaryData(EdmEntitySet entitySet, Object mediaLinkEntryData) throws ODataNotImplementedException, ODataNotFoundException, EdmException, ODataApplicationException {
        DataStore<Object> dataStore;
        Object readEntry;
        Object data = ANNOTATION_HELPER.getValueForField(mediaLinkEntryData, EdmMediaResourceContent.class);
        Object mimeType = ANNOTATION_HELPER.getValueForField(mediaLinkEntryData, EdmMediaResourceMimeType.class);
        if (data == null && mimeType == null && (readEntry = (dataStore = this.getDataStore(entitySet)).read(mediaLinkEntryData)) != null) {
            data = ANNOTATION_HELPER.getValueForField(readEntry, EdmMediaResourceContent.class);
            mimeType = ANNOTATION_HELPER.getValueForField(readEntry, EdmMediaResourceMimeType.class);
        }
        return new DataSource.BinaryData((byte[])data, String.valueOf(mimeType));
    }

    @Override
    public Object newDataObject(EdmEntitySet entitySet) throws ODataNotImplementedException, EdmException, ODataApplicationException {
        DataStore<Object> dataStore = this.getDataStore(entitySet);
        if (dataStore != null) {
            return dataStore.createInstance();
        }
        throw new AnnotationRuntimeException("No DataStore found for entitySet with name: " + entitySet.getName());
    }

    @Override
    public void writeBinaryData(EdmEntitySet entitySet, Object mediaEntityInstance, DataSource.BinaryData binaryData) throws ODataNotImplementedException, ODataNotFoundException, EdmException, ODataApplicationException {
        try {
            DataStore<Object> dataStore = this.getDataStore(entitySet);
            Object readEntry = dataStore.read(mediaEntityInstance);
            if (readEntry == null) {
                throw new ODataNotFoundException(ODataNotFoundException.ENTITY);
            }
            ANNOTATION_HELPER.setValueForAnnotatedField(mediaEntityInstance, EdmMediaResourceContent.class, binaryData.getData());
            ANNOTATION_HELPER.setValueForAnnotatedField(mediaEntityInstance, EdmMediaResourceMimeType.class, binaryData.getMimeType());
        }
        catch (AnnotationHelper.ODataAnnotationException e) {
            throw new AnnotationRuntimeException("Invalid media resource annotation at entity set '" + entitySet.getName() + "' with message '" + e.getMessage() + "'.", (Throwable)((Object)e));
        }
    }

    public Object updateData(EdmEntitySet entitySet, Object data) throws ODataNotImplementedException, EdmException, ODataApplicationException {
        DataStore<Object> dataStore = this.getDataStore(entitySet);
        return dataStore.update(data);
    }

    @Override
    public void deleteData(EdmEntitySet entitySet, Map<String, Object> keys) throws ODataNotImplementedException, ODataNotFoundException, EdmException, ODataApplicationException {
        DataStore<Object> dataStore = this.getDataStore(entitySet);
        Object keyInstance = dataStore.createInstance();
        ANNOTATION_HELPER.setKeyFields(keyInstance, keys);
        dataStore.delete(keyInstance);
    }

    @Override
    public void createData(EdmEntitySet entitySet, Object data) throws ODataNotImplementedException, EdmException, ODataApplicationException {
        DataStore<Object> dataStore = this.getDataStore(entitySet);
        dataStore.create(data);
    }

    @Override
    public void deleteRelation(EdmEntitySet sourceEntitySet, Object sourceData, EdmEntitySet targetEntitySet, Map<String, Object> targetKeys) throws ODataNotImplementedException, ODataNotFoundException, EdmException, ODataApplicationException {
        throw new ODataNotImplementedException(ODataNotImplementedException.COMMON);
    }

    @Override
    public void writeRelation(EdmEntitySet sourceEntitySet, Object sourceEntity, EdmEntitySet targetEntitySet, Map<String, Object> targetEntityValues) throws ODataNotImplementedException, ODataNotFoundException, EdmException, ODataApplicationException {
        DataStore<Object> sourceStore = this.dataStores.get(sourceEntitySet.getName());
        DataStore<Object> targetStore = this.dataStores.get(targetEntitySet.getName());
        AnnotationHelper.AnnotatedNavInfo commonNavInfo = ANNOTATION_HELPER.getCommonNavigationInfo(sourceStore.getDataTypeClass(), targetStore.getDataTypeClass());
        Field sourceField = commonNavInfo.getFromField();
        if (sourceField == null) {
            throw new AnnotationRuntimeException("Missing source field for related data (sourceStore='" + sourceStore + "', targetStore='" + targetStore + "').");
        }
        Object targetEntity = targetStore.createInstance();
        ANNOTATION_HELPER.setKeyFields(targetEntity, targetEntityValues);
        targetEntity = targetStore.read(targetEntity);
        this.setValueAtNavigationField(sourceEntity, sourceField, targetEntity);
        Field targetField = commonNavInfo.getToField();
        if (targetField != null) {
            this.setValueAtNavigationField(targetEntity, targetField, sourceEntity);
        }
    }

    private void setValueAtNavigationField(Object instance, Field field, Object value) throws EdmException {
        Class<?> fieldTypeClass = field.getType();
        if (Collection.class.isAssignableFrom(fieldTypeClass)) {
            ArrayList<Object> collection = (ArrayList<Object>)ANNOTATION_HELPER.getValueForField(instance, field.getName(), EdmNavigationProperty.class);
            if (collection == null) {
                collection = new ArrayList<Object>();
                this.setValue(instance, field, collection);
            }
            collection.add(value);
        } else {
            if (fieldTypeClass.isArray()) {
                throw new AnnotationRuntimeException("Write relations for internal used arrays is not supported.");
            }
            this.setValue(instance, field, value);
        }
    }

    private DataStore<Object> getDataStore(EdmEntitySet entitySet) throws EdmException {
        String name = entitySet.getName();
        DataStore<Object> dataStore = this.dataStores.get(name);
        if (dataStore == null) {
            throw new AnnotationRuntimeException("No DataStore found for entity set '" + entitySet + "'.");
        }
        return dataStore;
    }

    private Object getValue(Field field, Object instance) {
        try {
            boolean access = field.isAccessible();
            field.setAccessible(true);
            Object value = field.get(instance);
            field.setAccessible(access);
            return value;
        }
        catch (IllegalArgumentException e) {
            throw new AnnotationRuntimeException("Error for getting value of field '" + field + "' at instance '" + instance + "'.", e);
        }
        catch (IllegalAccessException e) {
            throw new AnnotationRuntimeException("Error for getting value of field '" + field + "' at instance '" + instance + "'.", e);
        }
    }

    private void setValue(Object instance, Field field, Object value) {
        try {
            boolean access = field.isAccessible();
            field.setAccessible(true);
            field.set(instance, value);
            field.setAccessible(access);
        }
        catch (IllegalArgumentException e) {
            throw new AnnotationRuntimeException("Error for setting value of field: '" + field + "' at instance: '" + instance + "'.", e);
        }
        catch (IllegalAccessException e) {
            throw new AnnotationRuntimeException("Error for setting value of field: '" + field + "' at instance: '" + instance + "'.", e);
        }
    }
}

