/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.util;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.nutch.plugin.PluginRepository;
import org.apache.nutch.util.LockUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NutchJob
extends Job {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String JOB_FAILURE_LOG_FORMAT = "%s job did not succeed, job id: %s, job status: %s, reason: %s";

    @Deprecated
    public NutchJob(Configuration conf, String jobName) throws IOException {
        super(conf, jobName);
        if (conf != null) {
            PluginRepository.get(conf);
        }
    }

    public static void cleanupAfterFailure(Path tempDir, FileSystem fs) throws IOException {
        NutchJob.cleanupAfterFailure(tempDir, null, fs);
    }

    public static void cleanupAfterFailure(Path tempDir, Path lock, FileSystem fs) throws IOException {
        try {
            if (fs.exists(tempDir)) {
                fs.delete(tempDir, true);
            }
            if (lock != null) {
                LockUtil.removeLockFile(fs, lock);
            }
        }
        catch (IOException e) {
            LOG.error("NutchJob cleanup failed: {}", (Object)e.getMessage());
            throw e;
        }
    }

    public static String getJobFailureLogMessage(String name, Job job) throws IOException, InterruptedException {
        if (job != null) {
            return String.format(JOB_FAILURE_LOG_FORMAT, name, job.getJobID(), job.getStatus().getState(), job.getStatus().getFailureInfo());
        }
        return "";
    }
}

