/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.scoring.similarity.util;

import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.en.EnglishMinimalStemFilter;
import org.apache.lucene.analysis.en.PorterStemFilter;
import org.apache.lucene.analysis.standard.ClassicTokenizer;

public class LuceneAnalyzerUtil
extends Analyzer {
    private static StemFilterType stemFilterType;
    private static CharArraySet stopSet;

    public LuceneAnalyzerUtil(StemFilterType stemFilterType, boolean useStopFilter) {
        LuceneAnalyzerUtil.stemFilterType = stemFilterType;
        stopSet = useStopFilter ? EnglishAnalyzer.ENGLISH_STOP_WORDS_SET : null;
    }

    public LuceneAnalyzerUtil(StemFilterType stemFilterType, List<String> stopWords, boolean addToDefault) {
        LuceneAnalyzerUtil.stemFilterType = stemFilterType;
        if (addToDefault) {
            stopSet.addAll(stopWords);
        } else {
            stopSet = StopFilter.makeStopSet(stopWords);
        }
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        ClassicTokenizer source = new ClassicTokenizer();
        LowerCaseFilter filter = new LowerCaseFilter((TokenStream)source);
        if (stopSet != null) {
            filter = new StopFilter((TokenStream)filter, stopSet);
        }
        switch (stemFilterType) {
            case PORTERSTEM_FILTER: {
                filter = new PorterStemFilter((TokenStream)filter);
                break;
            }
            case ENGLISHMINIMALSTEM_FILTER: {
                filter = new EnglishMinimalStemFilter((TokenStream)filter);
                break;
            }
        }
        return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)filter);
    }

    public static enum StemFilterType {
        PORTERSTEM_FILTER,
        ENGLISHMINIMALSTEM_FILTER,
        NONE;

    }
}

