/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security.support.expressiondsl.fields;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.client.security.support.expressiondsl.RoleMapperExpression;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class FieldRoleMapperExpression
implements RoleMapperExpression {
    private final String field;
    private final List<Object> values;

    public FieldRoleMapperExpression(String field, Object ... values) {
        if (field == null || field.isEmpty()) {
            throw new IllegalArgumentException("null or empty field name (" + field + ")");
        }
        if (values == null || values.length == 0) {
            throw new IllegalArgumentException("null or empty values for field (" + field + ")");
        }
        this.field = field;
        this.values = Collections.unmodifiableList(Arrays.asList(values));
    }

    public String getField() {
        return this.field;
    }

    public List<Object> getValues() {
        return this.values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldRoleMapperExpression that = (FieldRoleMapperExpression)o;
        return Objects.equals(this.getField(), that.getField()) && Objects.equals(this.getValues(), that.getValues());
    }

    public int hashCode() {
        int result = this.field.hashCode();
        result = 31 * result + this.values.hashCode();
        return result;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject("field");
        builder.startArray(this.field);
        for (Object value : this.values) {
            builder.value(value);
        }
        builder.endArray();
        builder.endObject();
        return builder.endObject();
    }

    public static FieldRoleMapperExpression ofUsername(Object ... values) {
        return FieldRoleMapperExpression.ofKeyValues("username", values);
    }

    public static FieldRoleMapperExpression ofGroups(Object ... values) {
        return FieldRoleMapperExpression.ofKeyValues("groups", values);
    }

    public static FieldRoleMapperExpression ofDN(Object ... values) {
        return FieldRoleMapperExpression.ofKeyValues("dn", values);
    }

    public static FieldRoleMapperExpression ofMetadata(String key, Object ... values) {
        if (!key.startsWith("metadata.")) {
            throw new IllegalArgumentException("metadata key must have prefix 'metadata.'");
        }
        return FieldRoleMapperExpression.ofKeyValues(key, values);
    }

    public static FieldRoleMapperExpression ofKeyValues(String key, Object ... values) {
        return new FieldRoleMapperExpression(key, values);
    }
}

