/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.sitemaps.sax;

import crawlercommons.sitemaps.AbstractSiteMap;
import crawlercommons.sitemaps.SiteMap;
import crawlercommons.sitemaps.SiteMapParser;
import crawlercommons.sitemaps.SiteMapURL;
import crawlercommons.sitemaps.sax.DelegatorHandler;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class AtomHandler
extends DelegatorHandler {
    private SiteMap sitemap;
    private URL loc;
    private String lastMod;
    boolean valid;
    private String rel;
    private int i = 0;

    AtomHandler(URL url, LinkedList<String> elementStack, boolean strict) {
        super(elementStack, strict);
        this.sitemap = new SiteMap(url);
        this.sitemap.setType(AbstractSiteMap.SitemapType.ATOM);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("entry".equals(localName)) {
            this.loc = null;
            this.lastMod = null;
            this.rel = null;
        } else if ("link".equals(localName)) {
            String href = attributes.getValue("href");
            if (href == null) {
                return;
            }
            SiteMapParser.LOG.debug("href = {}", (Object)href);
            boolean v = !this.isStrict() || SiteMapParser.urlIsValid(this.sitemap.getBaseUrl(), href);
            String r = attributes.getValue("rel");
            if (this.loc == null || !this.valid && v || this.rel != null && r == null) {
                try {
                    this.loc = new URL(href);
                    this.rel = r;
                    this.valid = v;
                }
                catch (MalformedURLException e) {
                    SiteMapParser.LOG.trace("Can't create an entry with a bad URL", (Throwable)e);
                    SiteMapParser.LOG.debug("Bad url: [{}]", (Object)href);
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("entry".equals(localName)) {
            this.maybeAddSiteMapUrl();
        } else if ("feed".equals(localName)) {
            this.sitemap.setProcessed(true);
        } else if ("updated".equals(localName)) {
            this.lastMod = this.getAndResetCharacterBuffer();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if ("updated".equals(this.currentElement())) {
            this.appendCharacterBuffer(ch, start, length);
        }
    }

    @Override
    public AbstractSiteMap getSiteMap() {
        return this.sitemap;
    }

    private void maybeAddSiteMapUrl() {
        if (this.valid) {
            if (this.loc == null) {
                SiteMapParser.LOG.debug("Missing url");
                SiteMapParser.LOG.trace("Can't create an entry with a missing URL");
            } else {
                String urlFiltered = (String)this.urlFilter.apply(this.loc.toString());
                if (urlFiltered == null) {
                    SiteMapParser.LOG.debug("Filtered URL {}", (Object)this.loc.toString());
                    return;
                }
                SiteMapURL sUrl = new SiteMapURL(urlFiltered, this.lastMod, null, null, this.valid);
                this.sitemap.addSiteMapUrl(sUrl);
                SiteMapParser.LOG.debug("  {}. {}", (Object)(++this.i), (Object)sUrl);
            }
        }
        this.loc = null;
        this.lastMod = null;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.maybeAddSiteMapUrl();
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.maybeAddSiteMapUrl();
    }
}

