/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath.xml.dtm.ref;

import net.sourceforge.htmlunit.xpath.xml.dtm.ref.ExtendedType;

public class ExpandedNameTable {
    private ExtendedType[] m_extendedTypes;
    private static final int m_initialSize = 128;
    private int m_nextType;
    public static final int ELEMENT = 1;
    public static final int ATTRIBUTE = 2;
    public static final int NAMESPACE = 13;
    final ExtendedType hashET = new ExtendedType(-1, "", "");
    private static final ExtendedType[] m_defaultExtendedTypes = new ExtendedType[14];
    private static final float m_loadFactor = 0.75f;
    private static final int m_initialCapacity = 203;
    private int m_capacity = 203;
    private int m_threshold = (int)((float)this.m_capacity * 0.75f);
    private HashEntry[] m_table = new HashEntry[this.m_capacity];

    public ExpandedNameTable() {
        this.initExtendedTypes();
    }

    private void initExtendedTypes() {
        this.m_extendedTypes = new ExtendedType[128];
        for (int i = 0; i < 14; ++i) {
            this.m_extendedTypes[i] = m_defaultExtendedTypes[i];
            this.m_table[i] = new HashEntry(m_defaultExtendedTypes[i], i, i, null);
        }
        this.m_nextType = 14;
    }

    public int getExpandedTypeID(String namespace, String localName, int type) {
        return this.getExpandedTypeID(namespace, localName, type, false);
    }

    public int getExpandedTypeID(String namespace, String localName, int type, boolean searchOnly) {
        HashEntry entry;
        if (null == namespace) {
            namespace = "";
        }
        if (null == localName) {
            localName = "";
        }
        int hash = type + namespace.hashCode() + localName.hashCode();
        this.hashET.redefine(type, namespace, localName, hash);
        int index = hash % this.m_capacity;
        if (index < 0) {
            index = -index;
        }
        HashEntry e = this.m_table[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(this.hashET)) {
                return e.value;
            }
            e = e.next;
        }
        if (searchOnly) {
            return -1;
        }
        if (this.m_nextType > this.m_threshold) {
            this.rehash();
            index = hash % this.m_capacity;
            if (index < 0) {
                index = -index;
            }
        }
        ExtendedType newET = new ExtendedType(type, namespace, localName, hash);
        if (this.m_extendedTypes.length == this.m_nextType) {
            ExtendedType[] newArray = new ExtendedType[this.m_extendedTypes.length * 2];
            System.arraycopy(this.m_extendedTypes, 0, newArray, 0, this.m_extendedTypes.length);
            this.m_extendedTypes = newArray;
        }
        this.m_extendedTypes[this.m_nextType] = newET;
        this.m_table[index] = entry = new HashEntry(newET, this.m_nextType, hash, this.m_table[index]);
        return this.m_nextType++;
    }

    private void rehash() {
        int newCapacity;
        int oldCapacity = this.m_capacity;
        HashEntry[] oldTable = this.m_table;
        this.m_capacity = newCapacity = 2 * oldCapacity + 1;
        this.m_threshold = (int)((float)newCapacity * 0.75f);
        this.m_table = new HashEntry[newCapacity];
        for (int i = oldCapacity - 1; i >= 0; --i) {
            HashEntry old = oldTable[i];
            while (old != null) {
                HashEntry e = old;
                old = old.next;
                int newIndex = e.hash % newCapacity;
                if (newIndex < 0) {
                    newIndex = -newIndex;
                }
                e.next = this.m_table[newIndex];
                this.m_table[newIndex] = e;
            }
        }
    }

    public int getExpandedTypeID(int type) {
        return type;
    }

    public final int getLocalNameID(int ExpandedNameID) {
        if (this.m_extendedTypes[ExpandedNameID].getLocalName().length() == 0) {
            return 0;
        }
        return ExpandedNameID;
    }

    public final int getNamespaceID(int ExpandedNameID) {
        if (this.m_extendedTypes[ExpandedNameID].getNamespace().length() == 0) {
            return 0;
        }
        return ExpandedNameID;
    }

    public final short getType(int ExpandedNameID) {
        return (short)this.m_extendedTypes[ExpandedNameID].getNodeType();
    }

    static {
        for (int i = 0; i < 14; ++i) {
            ExpandedNameTable.m_defaultExtendedTypes[i] = new ExtendedType(i, "", "");
        }
    }

    private static final class HashEntry {
        final ExtendedType key;
        final int value;
        final int hash;
        HashEntry next;

        private HashEntry(ExtendedType key, int value, int hash, HashEntry next) {
            this.key = key;
            this.value = value;
            this.hash = hash;
            this.next = next;
        }
    }
}

