/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciithemes;

import de.vandermeer.asciithemes.IsTextArt;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.StrBuilder;

public interface TA_CheckedItem
extends IsTextArt {
    default public String getLabel(boolean checked) {
        return checked ? this.getCheckedLabel() : this.getUncheckedLabel();
    }

    public String getCheckedLabel();

    public String getUncheckedLabel();

    default public StrBuilder toDoc() {
        StrBuilder ret = new StrBuilder(30);
        ret.append(this.getCheckedLabel()).append(" checked item").appendNewLine();
        ret.append(this.getUncheckedLabel()).append(" unchecked item");
        return ret;
    }

    public static TA_CheckedItem create(final Character checked, final Character unchecked, final String description) {
        Validate.notNull((Object)checked);
        Validate.notNull((Object)unchecked);
        Validate.notBlank((CharSequence)description);
        return new TA_CheckedItem(){

            @Override
            public String getUncheckedLabel() {
                return unchecked.toString();
            }

            @Override
            public String getCheckedLabel() {
                return checked.toString();
            }

            public String getDescription() {
                return description;
            }
        };
    }

    public static TA_CheckedItem create(final String checked, final String unchecked, final String description) {
        Validate.notNull((Object)checked);
        Validate.notNull((Object)unchecked);
        Validate.notBlank((CharSequence)description);
        return new TA_CheckedItem(){

            @Override
            public String getUncheckedLabel() {
                return unchecked.toString();
            }

            @Override
            public String getCheckedLabel() {
                return checked.toString();
            }

            public String getDescription() {
                return description;
            }
        };
    }
}

