/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang.math.LongRange;
import org.archive.util.ArchiveUtils;

public class FileUtils {
    private static final Logger LOGGER = Logger.getLogger(FileUtils.class.getName());
    protected static LinkedList<File> pendingDeletes = new LinkedList();

    private FileUtils() {
    }

    public static boolean copyFile(File src, File dest) throws FileNotFoundException, IOException {
        return FileUtils.copyFile(src, dest, -1L, true);
    }

    public static boolean copyFile(File src, File dest, long extent) throws FileNotFoundException, IOException {
        return FileUtils.copyFile(src, dest, extent, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File src, File dest, long extent, boolean overwrite) throws FileNotFoundException, IOException {
        boolean result;
        block16: {
            result = false;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Copying file " + src + " to " + dest + " extent " + extent + " exists " + dest.exists());
            }
            if (dest.exists()) {
                if (overwrite) {
                    dest.delete();
                    LOGGER.finer(dest.getAbsolutePath() + " removed before copy.");
                } else {
                    return result;
                }
            }
            FileInputStream fis = null;
            FileOutputStream fos = null;
            AbstractInterruptibleChannel fcin = null;
            AbstractInterruptibleChannel fcout = null;
            try {
                long trans;
                fis = new FileInputStream(src);
                fos = new FileOutputStream(dest);
                fcin = fis.getChannel();
                fcout = fos.getChannel();
                if (extent < 0L) {
                    extent = ((FileChannel)fcin).size();
                }
                if ((trans = ((FileChannel)fcin).transferTo(0L, extent, (WritableByteChannel)((Object)fcout))) < extent) {
                    result = false;
                }
                result = true;
            }
            catch (IOException e) {
                String message = "Copying " + src.getAbsolutePath() + " to " + dest.getAbsolutePath() + " with extent " + extent + " got IOE: " + e.getMessage();
                if (e instanceof ClosedByInterruptException || e.getMessage() != null && e.getMessage().equals("Invalid argument")) {
                    LOGGER.severe("Failed copy, trying workaround: " + message);
                    FileUtils.workaroundCopyFile(src, dest);
                    break block16;
                }
                IOException newE = new IOException(message);
                newE.initCause(e);
                throw newE;
            }
            finally {
                if (fcin != null) {
                    fcin.close();
                }
                if (fcout != null) {
                    fcout.close();
                }
                if (fis != null) {
                    fis.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void workaroundCopyFile(File src, File dest) throws IOException {
        FileInputStream from = null;
        FileOutputStream to = null;
        try {
            int bytesRead;
            from = new FileInputStream(src);
            to = new FileOutputStream(dest);
            byte[] buffer = new byte[4096];
            while ((bytesRead = from.read(buffer)) != -1) {
                to.write(buffer, 0, bytesRead);
            }
        }
        finally {
            if (from != null) {
                try {
                    from.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (to != null) {
                try {
                    to.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static File[] getFilesWithPrefix(File dir, final String prefix) {
        FileFilter prefixFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().toLowerCase().startsWith(prefix.toLowerCase());
            }
        };
        return dir.listFiles(prefixFilter);
    }

    public static IOFileFilter getRegexFileFilter(String regex) {
        class RegexFileFilter
        implements IOFileFilter {
            Pattern pattern;

            protected RegexFileFilter(String re) {
                this.pattern = Pattern.compile(re);
            }

            public boolean accept(File pathname) {
                return this.pattern.matcher(pathname.getName()).matches();
            }

            public boolean accept(File dir, String name) {
                return this.accept(new File(dir, name));
            }
        }
        return new RegexFileFilter(regex);
    }

    public static File assertReadable(File f) throws FileNotFoundException {
        if (!f.exists()) {
            throw new FileNotFoundException(f.getAbsolutePath() + " does not exist.");
        }
        if (!f.canRead()) {
            throw new FileNotFoundException(f.getAbsolutePath() + " is not readable.");
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isReadableWithExtensionAndMagic(File f, String uncompressedExtension, String magic) throws IOException {
        boolean result = false;
        FileUtils.assertReadable(f);
        if (f.getName().toLowerCase().endsWith(uncompressedExtension)) {
            try (FileInputStream fis = new FileInputStream(f);){
                byte[] b = new byte[magic.length()];
                int read = fis.read(b, 0, magic.length());
                fis.close();
                if (read == magic.length()) {
                    StringBuffer beginStr = new StringBuffer(magic.length());
                    for (int i = 0; i < magic.length(); ++i) {
                        beginStr.append((char)b[i]);
                    }
                    if (beginStr.toString().equalsIgnoreCase(magic)) {
                        result = true;
                    }
                }
            }
        }
        return result;
    }

    public static File maybeRelative(File context, String path) {
        File f = new File(path);
        if (f.isAbsolute()) {
            return f;
        }
        return new File(context, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(File file) throws IOException {
        FileInputStream finp = new FileInputStream(file);
        try {
            Properties p = new Properties();
            p.load(finp);
            Properties properties = p;
            return properties;
        }
        finally {
            ArchiveUtils.closeQuietly(finp);
        }
    }

    public static void storeProperties(Properties p, File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        try {
            p.store(fos, "");
        }
        finally {
            ArchiveUtils.closeQuietly(fos);
        }
    }

    public static boolean moveAsideIfExists(File file) throws IOException {
        if (!file.exists()) {
            return true;
        }
        String newName = file.getCanonicalPath() + "." + ArchiveUtils.get14DigitDate(file.lastModified());
        boolean retVal = file.renameTo(new File(newName));
        if (!retVal) {
            LOGGER.warning("unable to move aside: " + file + " to " + newName);
        }
        return retVal;
    }

    public static LongRange pagedLines(File file, long position, int signedDesiredLineCount, List<String> lines, int lineEstimate) throws IOException {
        int foundFullLines;
        int i;
        if (position < 0L) {
            position = file.length() + position;
        }
        if (lineEstimate == 0) {
            lineEstimate = 128;
        }
        int desiredLineCount = Math.abs(signedDesiredLineCount);
        long fileEnd = file.length();
        int bufferSize = (desiredLineCount + 5) * lineEstimate;
        long startPosition = signedDesiredLineCount > 0 ? position - 1L : position - (long)bufferSize + (long)(2 * lineEstimate);
        if (startPosition < 0L) {
            startPosition = 0L;
        }
        if (startPosition + (long)bufferSize > fileEnd) {
            bufferSize = (int)(fileEnd - startPosition);
        }
        FileInputStream fis = new FileInputStream(file);
        fis.getChannel().position(startPosition);
        byte[] buf = new byte[bufferSize];
        ArchiveUtils.readFully(fis, buf);
        IOUtils.closeQuietly((InputStream)fis);
        LinkedList<Integer> lineStarts = new LinkedList<Integer>();
        if (startPosition == 0L) {
            lineStarts.add(0);
        }
        boolean atLineEnd = false;
        boolean eatLF = false;
        for (i = 0; i < bufferSize; ++i) {
            if ((char)buf[i] == '\n' && eatLF) {
                eatLF = false;
                continue;
            }
            if (atLineEnd) {
                atLineEnd = false;
                lineStarts.add(i);
                if (signedDesiredLineCount < 0 && startPosition + (long)i > position) break;
            }
            if ((char)buf[i] == '\r') {
                atLineEnd = true;
                eatLF = true;
                continue;
            }
            if ((char)buf[i] != '\n') continue;
            atLineEnd = true;
        }
        if (startPosition + (long)i == fileEnd) {
            lineStarts.add(bufferSize);
        }
        if ((foundFullLines = lineStarts.size() - 1) < 1) {
            if (signedDesiredLineCount > 0) {
                if (startPosition + (long)bufferSize == fileEnd) {
                    return new LongRange(fileEnd, fileEnd);
                }
                return FileUtils.pagedLines(file, position, signedDesiredLineCount, lines, Math.max(bufferSize, lineEstimate));
            }
            return FileUtils.pagedLines(file, position, signedDesiredLineCount, lines, bufferSize);
        }
        while (signedDesiredLineCount > 0 && startPosition + (long)((Integer)lineStarts.getFirst()).intValue() < position) {
            lineStarts.removeFirst();
        }
        while (lineStarts.size() > desiredLineCount + 1) {
            if (signedDesiredLineCount < 0 && startPosition + (long)((Integer)lineStarts.get(1)).intValue() <= position) {
                lineStarts.removeFirst();
                continue;
            }
            lineStarts.removeLast();
        }
        int firstLine = (Integer)lineStarts.getFirst();
        int partialLine = (Integer)lineStarts.getLast();
        LongRange range = new LongRange(startPosition + (long)firstLine, startPosition + (long)partialLine);
        List foundLines = IOUtils.readLines((InputStream)new ByteArrayInputStream(buf, firstLine, partialLine - firstLine));
        if (foundFullLines < desiredLineCount && signedDesiredLineCount < 0 && startPosition > 0L) {
            range = FileUtils.expandRange(range, FileUtils.pagedLines(file, range.getMinimumLong() - 1L, signedDesiredLineCount + foundFullLines, lines, bufferSize / foundFullLines));
        }
        lines.addAll(foundLines);
        if (signedDesiredLineCount < 0 && range.getMaximumLong() < position) {
            range = FileUtils.expandRange(range, FileUtils.pagedLines(file, partialLine, 1, lines, bufferSize / foundFullLines));
        }
        if (signedDesiredLineCount > 0 && foundFullLines < desiredLineCount && range.getMaximumLong() < fileEnd) {
            range = FileUtils.expandRange(range, FileUtils.pagedLines(file, range.getMaximumLong(), desiredLineCount - foundFullLines, lines, bufferSize / foundFullLines));
        }
        return range;
    }

    public static LongRange expandRange(LongRange range1, LongRange range2) {
        return new LongRange(Math.min(range1.getMinimumLong(), range2.getMinimumLong()), Math.max(range1.getMaximumLong(), range2.getMaximumLong()));
    }

    public static LongRange pagedLines(File file, long position, int signedDesiredLongCount, List<String> lines) throws IOException {
        return FileUtils.pagedLines(file, position, signedDesiredLongCount, lines, 0);
    }

    public static synchronized void deleteSoonerOrLater(File fileToDelete) {
        pendingDeletes.add(fileToDelete);
        if (pendingDeletes.size() > 50) {
            LOGGER.warning(">50 pending Files to delete; forcing gc/finalization");
            System.gc();
            System.runFinalization();
        }
        ListIterator iter = pendingDeletes.listIterator();
        while (iter.hasNext()) {
            File pending = (File)iter.next();
            if (!pending.delete()) continue;
            iter.remove();
        }
        if (pendingDeletes.size() > 50) {
            LOGGER.severe(">50 pending Files to delete even after gc/finalization");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long readFullyToFile(InputStream is, File toFile) throws IOException {
        FileOutputStream os = org.apache.commons.io.FileUtils.openOutputStream((File)toFile);
        try {
            long l = IOUtils.copyLarge((InputStream)is, (OutputStream)os);
            return l;
        }
        finally {
            IOUtils.closeQuietly((OutputStream)os);
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    public static File ensureWriteableDirectory(String dir) throws IOException {
        return FileUtils.ensureWriteableDirectory(new File(dir));
    }

    public static List<File> ensureWriteableDirectory(List<File> dirs) throws IOException {
        Iterator<File> i = dirs.iterator();
        while (i.hasNext()) {
            FileUtils.ensureWriteableDirectory(i.next());
        }
        return dirs;
    }

    public static File ensureWriteableDirectory(File dir) throws IOException {
        if (!dir.exists()) {
            boolean success = dir.mkdirs();
            if (!success) {
                throw new IOException("Failed to create directory: " + dir);
            }
        } else {
            if (!dir.canWrite()) {
                throw new IOException("Dir " + dir.getAbsolutePath() + " not writeable.");
            }
            if (!dir.isDirectory()) {
                throw new IOException("Dir " + dir.getAbsolutePath() + " is not a directory.");
            }
        }
        return dir;
    }

    public static File tryToCanonicalize(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return file;
        }
    }

    public static void appendTo(File fileToAppendTo, File fileToAppendFrom) throws IOException {
        byte[] buf = new byte[65536];
        FileOutputStream out = new FileOutputStream(fileToAppendTo, true);
        FileInputStream in = new FileInputStream(fileToAppendFrom);
        int n = in.read(buf);
        while (n > 0) {
            out.write(buf, 0, n);
            n = in.read(buf);
        }
        in.close();
        out.flush();
        out.close();
    }
}

