/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Iterator;
import java.util.LinkedList;
import org.archive.util.FileUtils;

public class ObjectPlusFilesInputStream
extends ObjectInputStream {
    protected LinkedList<File> auxiliaryDirectoryStack = new LinkedList();
    protected LinkedList<Runnable> postRestoreTasks = new LinkedList();

    public ObjectPlusFilesInputStream(InputStream in, File storeDir) throws IOException {
        super(in);
        this.auxiliaryDirectoryStack.addFirst(storeDir);
    }

    public void pushAuxiliaryDirectory(String dir) {
        this.auxiliaryDirectoryStack.addFirst(new File(this.getAuxiliaryDirectory(), dir));
    }

    public void popAuxiliaryDirectory() {
        this.auxiliaryDirectoryStack.removeFirst();
    }

    public File getAuxiliaryDirectory() {
        return this.auxiliaryDirectoryStack.getFirst();
    }

    public void restoreFile(File destination) throws IOException {
        String nameAsStored = this.readUTF();
        long lengthAtStoreTime = this.readLong();
        File storedFile = new File(this.getAuxiliaryDirectory(), nameAsStored);
        FileUtils.copyFile(storedFile, destination, lengthAtStoreTime);
    }

    public void restoreFileTo(File directory) throws IOException {
        String nameAsStored = this.readUTF();
        long lengthAtStoreTime = this.readLong();
        File storedFile = new File(this.getAuxiliaryDirectory(), nameAsStored);
        File destination = new File(directory, nameAsStored);
        FileUtils.copyFile(storedFile, destination, lengthAtStoreTime);
    }

    public void registerFinishTask(Runnable task) {
        this.postRestoreTasks.addFirst(task);
    }

    private void doFinishTasks() {
        Iterator iter = this.postRestoreTasks.iterator();
        while (iter.hasNext()) {
            ((Runnable)iter.next()).run();
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.doFinishTasks();
    }
}

