/*
 * Decompiled with CFR 0.152.
 */
package com.barchart.udt;

import com.barchart.udt.CCC;
import com.barchart.udt.FactoryInterfaceUDT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FactoryUDT<C>
implements FactoryInterfaceUDT {
    C classType;
    final Class<C> clazz;
    Logger log = LoggerFactory.getLogger(FactoryUDT.class);
    boolean doInit = false;
    boolean doClose = false;
    boolean doOnACK = false;
    boolean doOnLoss = false;
    boolean doOnTimeout = false;

    public FactoryUDT(Class<C> clazz) {
        this.clazz = clazz;
        if (!CCC.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Generic argument 'C' must be 'CCC' class or extension");
        }
        try {
            if (clazz.getMethod("init", new Class[0]).getDeclaringClass() != CCC.class) {
                this.doInit = true;
            }
            if (clazz.getMethod("close", new Class[0]).getDeclaringClass() != CCC.class) {
                this.doClose = true;
            }
            if (clazz.getMethod("onACK", Integer.TYPE).getDeclaringClass() != CCC.class) {
                this.doOnACK = true;
            }
            if (clazz.getMethod("onLoss", int[].class).getDeclaringClass() != CCC.class) {
                this.doOnLoss = true;
            }
            if (clazz.getMethod("onTimeout", new Class[0]).getDeclaringClass() != CCC.class) {
                this.doOnTimeout = true;
            }
        }
        catch (SecurityException e) {
            this.log.error("Error setting up class factory", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            this.log.error("Expected CCC method doesn't exsit", (Throwable)e);
        }
    }

    @Override
    public CCC create() {
        try {
            C cccObj = this.clazz.newInstance();
            return (CCC)cccObj;
        }
        catch (InstantiationException e) {
            this.log.error("Failed to instansiate CCC class", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.log.error("Failed to instansiate CCC class", (Throwable)e);
        }
        return null;
    }

    @Override
    public FactoryInterfaceUDT cloneFactory() {
        return new FactoryUDT<C>(this.clazz);
    }
}

