/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.tika;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.XMPDM;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.gagravarr.ogg.OggFile;
import org.gagravarr.ogg.OggStreamIdentifier;
import org.gagravarr.tika.OggAudioParser;
import org.gagravarr.vorbis.VorbisFile;
import org.gagravarr.vorbis.VorbisInfo;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VorbisParser
extends OggAudioParser {
    private static final long serialVersionUID = 5904981674814527529L;
    protected static final MediaType OGG_VORBIS = MediaType.parse((String)OggStreamIdentifier.OGG_VORBIS.mimetype);
    private static List<MediaType> TYPES = Arrays.asList(OGG_VORBIS);

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return new HashSet<MediaType>(TYPES);
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, TikaException, SAXException {
        metadata.set("Content-Type", OGG_VORBIS.toString());
        metadata.set(XMPDM.AUDIO_COMPRESSOR, "Vorbis");
        OggFile ogg = new OggFile(stream);
        VorbisFile vorbis = new VorbisFile(ogg);
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        this.extractInfo(metadata, vorbis.getInfo());
        VorbisParser.extractComments(metadata, xhtml, vorbis.getComment());
        VorbisParser.extractDuration(metadata, xhtml, vorbis, vorbis);
        xhtml.endDocument();
        vorbis.close();
    }

    protected void extractInfo(Metadata metadata, VorbisInfo info) throws TikaException {
        metadata.set(XMPDM.AUDIO_SAMPLE_RATE, (int)info.getRate());
        metadata.add("version", "Vorbis " + info.getVersion());
        VorbisParser.extractChannelInfo(metadata, info);
    }
}

