/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.client.impl;

import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.client.ConnectionClient;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.toolkit.client.RequestConfig;
import org.apache.nifi.toolkit.client.impl.AbstractJerseyClient;
import org.apache.nifi.web.api.entity.ConnectionEntity;
import org.apache.nifi.web.api.entity.DropRequestEntity;
import org.apache.nifi.web.api.entity.FlowFileEntity;
import org.apache.nifi.web.api.entity.ListingRequestEntity;

public class JerseyConnectionClient
extends AbstractJerseyClient
implements ConnectionClient {
    private volatile WebTarget connectionTarget;
    private volatile WebTarget processGroupTarget;
    private volatile WebTarget flowFileQueueTarget;

    public JerseyConnectionClient(WebTarget baseTarget) {
        this(baseTarget, null);
    }

    public JerseyConnectionClient(WebTarget baseTarget, RequestConfig requestConfig) {
        super(requestConfig);
        this.connectionTarget = baseTarget.path("/connections/{id}");
        this.processGroupTarget = baseTarget.path("/process-groups/{pgId}");
        this.flowFileQueueTarget = baseTarget.path("/flowfile-queues/{id}");
    }

    @Override
    public void acknowledgeDisconnectedNode() {
        this.connectionTarget = this.connectionTarget.queryParam("disconnectedNodeAcknowledged", new Object[]{true});
        this.processGroupTarget = this.processGroupTarget.queryParam("disconnectedNodeAcknowledged", new Object[]{true});
        this.flowFileQueueTarget = this.flowFileQueueTarget.queryParam("disconnectedNodeAcknowledged", new Object[]{true});
    }

    @Override
    public ConnectionEntity getConnection(String id) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("Connection id cannot be null or blank");
        }
        return this.executeAction("Error getting connection", () -> {
            WebTarget target = this.connectionTarget.resolveTemplate("id", (Object)id);
            return (ConnectionEntity)this.getRequestBuilder(target).get(ConnectionEntity.class);
        });
    }

    @Override
    public ConnectionEntity deleteConnection(String id, String clientId, long version) throws NiFiClientException, IOException {
        return this.deleteConnection(id, clientId, version, false);
    }

    public ConnectionEntity deleteConnection(String id, String clientId, long version, Boolean nodeDisconnectionAcknowledged) throws NiFiClientException, IOException {
        if (id == null) {
            throw new IllegalArgumentException("Connection id cannot be null");
        }
        return this.executeAction("Error deleting Connection", () -> {
            WebTarget target = this.connectionTarget.queryParam("version", new Object[]{version}).queryParam("clientId", new Object[]{clientId}).resolveTemplate("id", (Object)id);
            if (nodeDisconnectionAcknowledged == Boolean.TRUE) {
                target = target.queryParam("disconnectedNodeAcknowledged", new Object[]{true});
            }
            return (ConnectionEntity)this.getRequestBuilder(target).delete(ConnectionEntity.class);
        });
    }

    @Override
    public ConnectionEntity deleteConnection(ConnectionEntity connectionEntity) throws NiFiClientException, IOException {
        if (connectionEntity == null) {
            throw new IllegalArgumentException("Connection Entity cannot be null");
        }
        if (connectionEntity.getRevision() == null) {
            throw new IllegalArgumentException("Revision cannot be null");
        }
        return this.deleteConnection(connectionEntity.getId(), connectionEntity.getRevision().getClientId(), connectionEntity.getRevision().getVersion(), connectionEntity.isDisconnectedNodeAcknowledged());
    }

    @Override
    public ConnectionEntity createConnection(String parentGroupdId, ConnectionEntity connectionEntity) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)parentGroupdId)) {
            throw new IllegalArgumentException("Parent process group id cannot be null or blank");
        }
        if (connectionEntity == null) {
            throw new IllegalArgumentException("Connection entity cannot be null");
        }
        return this.executeAction("Error creating Connection", () -> {
            WebTarget target = this.processGroupTarget.path("/connections").resolveTemplate("pgId", (Object)parentGroupdId);
            return (ConnectionEntity)this.getRequestBuilder(target).post(Entity.entity((Object)connectionEntity, (MediaType)MediaType.APPLICATION_JSON_TYPE), ConnectionEntity.class);
        });
    }

    @Override
    public ConnectionEntity updateConnection(ConnectionEntity connectionEntity) throws NiFiClientException, IOException {
        if (connectionEntity == null) {
            throw new IllegalArgumentException("Connection entity cannot be null");
        }
        return this.executeAction("Error updating Connection", () -> {
            WebTarget target = this.connectionTarget.resolveTemplate("id", (Object)connectionEntity.getId());
            return (ConnectionEntity)this.getRequestBuilder(target).put(Entity.entity((Object)connectionEntity, (MediaType)MediaType.APPLICATION_JSON_TYPE), ConnectionEntity.class);
        });
    }

    @Override
    public DropRequestEntity emptyQueue(String connectionId) throws NiFiClientException, IOException {
        if (connectionId == null) {
            throw new IllegalArgumentException("Connection ID cannot be null");
        }
        return this.executeAction("Error empty queue for Connection", () -> {
            WebTarget target = this.flowFileQueueTarget.path("drop-requests").resolveTemplate("id", (Object)connectionId);
            return (DropRequestEntity)this.getRequestBuilder(target).post(Entity.entity((Object)connectionId, (String)"text/plain"), DropRequestEntity.class);
        });
    }

    @Override
    public DropRequestEntity getDropRequest(String connectionId, String dropRequestId) throws NiFiClientException, IOException {
        if (connectionId == null) {
            throw new IllegalArgumentException("Connection ID cannot be null");
        }
        if (dropRequestId == null) {
            throw new IllegalArgumentException("Drop Request ID cannot be null");
        }
        return this.executeAction("Error retrieving Drop Request", () -> {
            WebTarget target = this.flowFileQueueTarget.path("drop-requests/{requestId}").resolveTemplate("id", (Object)connectionId).resolveTemplate("requestId", (Object)dropRequestId);
            return (DropRequestEntity)this.getRequestBuilder(target).get(DropRequestEntity.class);
        });
    }

    @Override
    public DropRequestEntity deleteDropRequest(String connectionId, String dropRequestId) throws NiFiClientException, IOException {
        if (connectionId == null) {
            throw new IllegalArgumentException("Connection ID cannot be null");
        }
        if (dropRequestId == null) {
            throw new IllegalArgumentException("Drop Request ID cannot be null");
        }
        return this.executeAction("Error retrieving Drop Request", () -> {
            WebTarget target = this.flowFileQueueTarget.path("drop-requests/{requestId}").resolveTemplate("id", (Object)connectionId).resolveTemplate("requestId", (Object)dropRequestId);
            return (DropRequestEntity)this.getRequestBuilder(target).delete(DropRequestEntity.class);
        });
    }

    @Override
    public ListingRequestEntity listQueue(String connectionId) throws NiFiClientException, IOException {
        if (connectionId == null) {
            throw new IllegalArgumentException("Connection ID cannot be null");
        }
        return this.executeAction("Error listing queue for Connection", () -> {
            WebTarget target = this.flowFileQueueTarget.path("listing-requests").resolveTemplate("id", (Object)connectionId);
            return (ListingRequestEntity)this.getRequestBuilder(target).post(Entity.entity((Object)connectionId, (String)"text/plain"), ListingRequestEntity.class);
        });
    }

    @Override
    public ListingRequestEntity getListingRequest(String connectionId, String listingRequestId) throws NiFiClientException, IOException {
        if (connectionId == null) {
            throw new IllegalArgumentException("Connection ID cannot be null");
        }
        if (listingRequestId == null) {
            throw new IllegalArgumentException("Listing Request ID cannot be null");
        }
        return this.executeAction("Error retrieving Listing Request", () -> {
            WebTarget target = this.flowFileQueueTarget.path("listing-requests/{requestId}").resolveTemplate("id", (Object)connectionId).resolveTemplate("requestId", (Object)listingRequestId);
            return (ListingRequestEntity)this.getRequestBuilder(target).get(ListingRequestEntity.class);
        });
    }

    @Override
    public ListingRequestEntity deleteListingRequest(String connectionId, String listingRequestId) throws NiFiClientException, IOException {
        if (connectionId == null) {
            throw new IllegalArgumentException("Connection ID cannot be null");
        }
        if (listingRequestId == null) {
            throw new IllegalArgumentException("Listing Request ID cannot be null");
        }
        return this.executeAction("Error retrieving Listing Request", () -> {
            WebTarget target = this.flowFileQueueTarget.path("listing-requests/{requestId}").resolveTemplate("id", (Object)connectionId).resolveTemplate("requestId", (Object)listingRequestId);
            return (ListingRequestEntity)this.getRequestBuilder(target).delete(ListingRequestEntity.class);
        });
    }

    @Override
    public FlowFileEntity getFlowFile(String connectionId, String flowFileUuid) throws NiFiClientException, IOException {
        return this.getFlowFile(connectionId, flowFileUuid, null);
    }

    @Override
    public FlowFileEntity getFlowFile(String connectionId, String flowFileUuid, String nodeId) throws NiFiClientException, IOException {
        if (connectionId == null) {
            throw new IllegalArgumentException("Connection ID cannot be null");
        }
        if (flowFileUuid == null) {
            throw new IllegalArgumentException("FlowFile UUID cannot be null");
        }
        return this.executeAction("Error retrieving FlowFile", () -> {
            WebTarget target = this.flowFileQueueTarget.path("flowfiles/{uuid}").resolveTemplate("id", (Object)connectionId).resolveTemplate("uuid", (Object)flowFileUuid);
            if (nodeId != null) {
                target = target.queryParam("clusterNodeId", new Object[]{nodeId});
            }
            return (FlowFileEntity)this.getRequestBuilder(target).get(FlowFileEntity.class);
        });
    }

    @Override
    public InputStream getFlowFileContent(String connectionId, String flowFileUuid, String nodeId) throws NiFiClientException, IOException {
        if (connectionId == null) {
            throw new IllegalArgumentException("Connection ID cannot be null");
        }
        if (flowFileUuid == null) {
            throw new IllegalArgumentException("FlowFile UUID cannot be null");
        }
        return this.executeAction("Error retrieving FlowFile Content", () -> {
            WebTarget target = this.flowFileQueueTarget.path("flowfiles/{uuid}/content").resolveTemplate("id", (Object)connectionId).resolveTemplate("uuid", (Object)flowFileUuid);
            if (nodeId != null) {
                target = target.queryParam("clusterNodeId", new Object[]{nodeId});
            }
            return (InputStream)this.getRequestBuilder(target).get(InputStream.class);
        });
    }
}

