/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository.metrics;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.controller.repository.FlowFileEvent;
import org.apache.nifi.controller.repository.metrics.EmptyFlowFileEvent;
import org.apache.nifi.controller.repository.metrics.EventContainer;
import org.apache.nifi.controller.repository.metrics.EventSum;
import org.apache.nifi.controller.repository.metrics.EventSumValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecondPrecisionEventContainer
implements EventContainer {
    private static final Logger logger = LoggerFactory.getLogger(SecondPrecisionEventContainer.class);
    private final int numBins;
    private final EventSum[] sums;
    private final EventSumValue aggregateValue = new EventSumValue(0L);
    private final AtomicLong lastUpdateSecond = new AtomicLong(System.currentTimeMillis() / 1000L);

    public SecondPrecisionEventContainer(int numMinutes) {
        this.numBins = numMinutes * 60 + 1;
        this.sums = new EventSum[this.numBins];
        for (int i = 0; i < this.numBins; ++i) {
            this.sums[i] = new EventSum();
        }
    }

    @Override
    public void addEvent(FlowFileEvent event) {
        this.addEvent(event, System.currentTimeMillis());
    }

    protected void addEvent(FlowFileEvent event, long timestamp) {
        long second = timestamp / 1000L;
        int binIdx = (int)(second % (long)this.numBins);
        EventSum sum = this.sums[binIdx];
        EventSumValue replaced = sum.addOrReset(event, timestamp);
        this.aggregateValue.add(event);
        if (replaced == null) {
            logger.debug("Updated bin {}. Did NOT replace.", (Object)binIdx);
        } else {
            logger.debug("Replaced bin {}", (Object)binIdx);
            this.aggregateValue.subtract(replaced);
        }
        this.processExpiredBuckets(second);
    }

    private void processExpiredBuckets(long currentSecond) {
        boolean updated;
        long lastUpdate = this.lastUpdateSecond.get();
        if (currentSecond > lastUpdate && (updated = this.lastUpdateSecond.compareAndSet(lastUpdate, currentSecond))) {
            if (lastUpdate == 0L) {
                return;
            }
            int secondsElapsed = (int)(currentSecond - lastUpdate);
            int index = (int)(currentSecond % (long)this.numBins);
            long expirationTimestamp = 1000L * (currentSecond - (long)this.numBins);
            int expired = 0;
            for (int i = 0; i < secondsElapsed; ++i) {
                EventSum expiredSum;
                EventSumValue expiredValue;
                if (--index < 0) {
                    index = this.sums.length - 1;
                }
                if ((expiredValue = (expiredSum = this.sums[index]).reset(expirationTimestamp)) == null) continue;
                this.aggregateValue.subtract(expiredValue);
                ++expired;
            }
            logger.debug("Expired {} bins", (Object)expired);
        }
    }

    @Override
    public void purgeEvents(long cutoffEpochMilliseconds) {
    }

    @Override
    public FlowFileEvent generateReport(long now) {
        long second = now / 1000L + 1L;
        long lastUpdate = this.lastUpdateSecond.get();
        long secondsSinceUpdate = second - lastUpdate;
        if (secondsSinceUpdate > (long)this.numBins) {
            logger.debug("EventContainer hasn't been updated in {} seconds so will generate report as Empty FlowFile Event", (Object)secondsSinceUpdate);
            return EmptyFlowFileEvent.INSTANCE;
        }
        logger.debug("Will expire up to {} bins", (Object)secondsSinceUpdate);
        this.processExpiredBuckets(second);
        return this.aggregateValue.toFlowFileEvent();
    }
}

