/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.s2s;

import java.io.IOException;
import java.io.InputStream;
import org.apache.nifi.remote.Transaction;
import org.apache.nifi.remote.TransactionCompletion;
import org.apache.nifi.remote.TransferDirection;
import org.apache.nifi.remote.client.SiteToSiteClient;
import org.apache.nifi.toolkit.s2s.DataPacketDto;

public class SiteToSiteSender {
    private final SiteToSiteClient siteToSiteClient;
    private final InputStream input;

    public SiteToSiteSender(SiteToSiteClient siteToSiteClient, InputStream input) {
        this.siteToSiteClient = siteToSiteClient;
        this.input = input;
    }

    public TransactionCompletion sendFiles() throws IOException {
        Transaction transaction = this.siteToSiteClient.createTransaction(TransferDirection.SEND);
        try {
            DataPacketDto.getDataPacketStream(this.input).forEachOrdered(d -> {
                try {
                    transaction.send(d);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException(e.getMessage(), e);
        }
        transaction.confirm();
        return transaction.complete();
    }
}

