/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.nodes;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ControllerClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.nifi.NodeResult;
import org.apache.nifi.web.api.dto.NodeDTO;
import org.apache.nifi.web.api.entity.NodeEntity;

public class DisconnectNode
extends AbstractNiFiCommand<NodeResult> {
    public DisconnectNode() {
        super("disconnect-node", NodeResult.class);
    }

    @Override
    public String getDescription() {
        return "Disconnects a node from the NiFi cluster.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.NIFI_NODE_ID.createOption());
    }

    @Override
    public NodeResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String nodeId = this.getRequiredArg(properties, CommandOption.NIFI_NODE_ID);
        ControllerClient controllerClient = client.getControllerClient();
        NodeDTO nodeDto = new NodeDTO();
        nodeDto.setNodeId(nodeId);
        nodeDto.setStatus("DISCONNECTING");
        NodeEntity nodeEntity = new NodeEntity();
        nodeEntity.setNode(nodeDto);
        NodeEntity nodeEntityResult = controllerClient.disconnectNode(nodeId, nodeEntity);
        return new NodeResult(this.getResultType(properties), nodeEntityResult);
    }
}

