/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.str;

import io.questdb.std.Numbers;
import io.questdb.std.Sinkable;
import io.questdb.std.Unsafe;
import io.questdb.std.datetime.microtime.TimestampFormatUtils;
import io.questdb.std.datetime.millitime.DateFormatUtils;
import io.questdb.std.str.CharSinkBase;

public interface CharSink
extends CharSinkBase {
    public int encodeSurrogate(char var1, CharSequence var2, int var3, int var4);

    default public CharSink encodeUtf8(CharSequence cs) {
        return this.encodeUtf8(cs, 0, cs.length());
    }

    default public CharSink encodeUtf8(CharSequence cs, int lo, int hi) {
        int i = lo;
        while (i < hi) {
            char c;
            if ((c = cs.charAt(i++)) < '\u0080') {
                this.putUtf8Special(c);
                continue;
            }
            i = this.putUtf8Internal(cs, hi, i, c);
        }
        return this;
    }

    default public CharSink encodeUtf8AndQuote(CharSequence cs) {
        this.put('\"').encodeUtf8(cs).put('\"');
        return this;
    }

    default public void fill(char c, int n) {
        for (int i = 0; i < n; ++i) {
            this.put(c);
        }
    }

    default public void flush() {
    }

    default public char[] getDoubleDigitsBuffer() {
        throw new UnsupportedOperationException();
    }

    default public CharSink put(CharSequence cs) {
        throw new UnsupportedOperationException();
    }

    default public CharSink put(CharSequence cs, int lo, int hi) {
        for (int i = lo; i < hi; ++i) {
            this.put(cs.charAt(i));
        }
        return this;
    }

    @Override
    public CharSink put(char var1);

    default public CharSink put(int value) {
        Numbers.append(this, value);
        return this;
    }

    default public CharSink put(long value) {
        Numbers.append(this, value);
        return this;
    }

    default public CharSink put(long lo, long hi) {
        for (long addr = lo; addr < hi; addr += 2L) {
            this.put(Unsafe.getUnsafe().getChar(addr));
        }
        return this;
    }

    default public CharSink put(float value, int scale) {
        Numbers.append(this, value, scale);
        return this;
    }

    default public CharSink put(double value) {
        Numbers.append(this, value);
        return this;
    }

    default public CharSink put(double value, int scale) {
        Numbers.append(this, value, scale);
        return this;
    }

    default public CharSink put(boolean value) {
        this.put(value ? "true" : "false");
        return this;
    }

    default public CharSink put(Throwable e) {
        throw new UnsupportedOperationException();
    }

    default public CharSink put(Sinkable sinkable) {
        sinkable.toSink(this);
        return this;
    }

    default public CharSink put(char[] chars, int start, int len) {
        for (int i = 0; i < len; ++i) {
            this.put(chars[i + start]);
        }
        return this;
    }

    default public CharSink putISODate(long value) {
        TimestampFormatUtils.appendDateTimeUSec(this, value);
        return this;
    }

    default public CharSink putISODateMillis(long value) {
        DateFormatUtils.appendDateTime(this, value);
        return this;
    }

    default public CharSink putQuoted(CharSequence cs) {
        this.put('\"').put(cs).put('\"');
        return this;
    }

    default public CharSink putUtf8(char c) {
        if (c < '\u0080') {
            this.putUtf8Special(c);
        } else if (c < '\u0800') {
            this.put((char)(0xC0 | c >> 6)).put((char)(0x80 | c & 0x3F));
        } else if (Character.isSurrogate(c)) {
            this.put('?');
        } else {
            this.put((char)(0xE0 | c >> 12)).put((char)(0x80 | c >> 6 & 0x3F)).put((char)(0x80 | c & 0x3F));
        }
        return this;
    }

    default public int putUtf8Internal(CharSequence cs, int hi, int i, char c) {
        if (c < '\u0800') {
            this.put((char)(0xC0 | c >> 6)).put((char)(0x80 | c & 0x3F));
        } else if (Character.isSurrogate(c)) {
            i = this.encodeSurrogate(c, cs, i, hi);
        } else {
            this.put((char)(0xE0 | c >> 12)).put((char)(0x80 | c >> 6 & 0x3F)).put((char)(0x80 | c & 0x3F));
        }
        return i;
    }

    default public void putUtf8Special(char c) {
        this.put(c);
    }
}

