/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography.implementation;

import com.azure.security.keyvault.keys.cryptography.implementation.HashAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.SignatureAlgorithm;
import java.util.HashMap;
import java.util.Map;

final class SignatureHashResolver {
    public static final SignatureHashResolver DEFAULT;
    private final Map<SignatureAlgorithm, HashAlgorithm> algorithms;

    private SignatureHashResolver(Map<SignatureAlgorithm, HashAlgorithm> algorithms) {
        this.algorithms = algorithms;
    }

    public HashAlgorithm get(SignatureAlgorithm signatureAlgorithm) {
        return this.algorithms.get((Object)signatureAlgorithm);
    }

    static {
        HashMap<SignatureAlgorithm, HashAlgorithm> defaultAlgorithms = new HashMap<SignatureAlgorithm, HashAlgorithm>();
        defaultAlgorithms.put(SignatureAlgorithm.ES256, HashAlgorithm.SHA_256);
        defaultAlgorithms.put(SignatureAlgorithm.ES256K, HashAlgorithm.SHA_256);
        defaultAlgorithms.put(SignatureAlgorithm.ES384, HashAlgorithm.SHA_384);
        defaultAlgorithms.put(SignatureAlgorithm.ES512, HashAlgorithm.SHA_512);
        defaultAlgorithms.put(SignatureAlgorithm.RS256, HashAlgorithm.SHA_256);
        defaultAlgorithms.put(SignatureAlgorithm.RS384, HashAlgorithm.SHA_384);
        defaultAlgorithms.put(SignatureAlgorithm.RS512, HashAlgorithm.SHA_512);
        defaultAlgorithms.put(SignatureAlgorithm.PS256, HashAlgorithm.SHA_256);
        defaultAlgorithms.put(SignatureAlgorithm.PS512, HashAlgorithm.SHA_512);
        defaultAlgorithms.put(SignatureAlgorithm.PS384, HashAlgorithm.SHA_384);
        DEFAULT = new SignatureHashResolver(defaultAlgorithms);
    }
}

