/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto.util;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class TimezoneAdapter
extends XmlAdapter<String, Date> {
    public static final String DEFAULT_DATE_TIME_FORMAT = "z";
    private static final ZoneId ZONE_ID = TimeZone.getDefault().toZoneId();

    public String marshal(Date date) throws Exception {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(DEFAULT_DATE_TIME_FORMAT, Locale.US);
        ZonedDateTime localDateTime = ZonedDateTime.ofInstant(date.toInstant(), ZONE_ID);
        return formatter.format(localDateTime);
    }

    public Date unmarshal(String date) throws Exception {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter parser = new DateTimeFormatterBuilder().appendPattern(DEFAULT_DATE_TIME_FORMAT).parseDefaulting(ChronoField.YEAR, now.getYear()).parseDefaulting(ChronoField.MONTH_OF_YEAR, now.getMonthValue()).parseDefaulting(ChronoField.DAY_OF_MONTH, now.getDayOfMonth()).parseDefaulting(ChronoField.HOUR_OF_DAY, now.getHour()).parseDefaulting(ChronoField.MINUTE_OF_HOUR, now.getMinute()).parseDefaulting(ChronoField.SECOND_OF_MINUTE, now.getSecond()).parseDefaulting(ChronoField.MILLI_OF_SECOND, 0L).toFormatter(Locale.US);
        LocalDateTime parsedDateTime = LocalDateTime.parse(date, parser);
        return Date.from(parsedDateTime.toInstant(ZONE_ID.getRules().getOffset(now)));
    }
}

