/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.remote.RemoteSiteListener;
import org.apache.nifi.remote.protocol.FlowFileTransaction;
import org.apache.nifi.remote.protocol.HandshakeProperties;
import org.apache.nifi.remote.protocol.http.HttpFlowFileServerProtocol;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRemoteSiteListener
implements RemoteSiteListener {
    private static final Logger logger = LoggerFactory.getLogger(HttpRemoteSiteListener.class);
    private final int transactionTtlSec;
    private static HttpRemoteSiteListener instance;
    private final Map<String, TransactionWrapper> transactions = new ConcurrentHashMap<String, TransactionWrapper>();
    private final ScheduledExecutorService taskExecutor = Executors.newScheduledThreadPool(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setName("Http Site-to-Site Transaction Maintenance");
            thread.setDaemon(true);
            return thread;
        }
    });
    private ProcessGroup rootGroup;
    private ScheduledFuture<?> transactionMaintenanceTask;

    private HttpRemoteSiteListener(NiFiProperties nifiProperties) {
        int txTtlSec;
        try {
            String snapshotFrequency = nifiProperties.getProperty("nifi.remote.input.http.transaction.ttl", "30 secs");
            txTtlSec = (int)FormatUtils.getTimeDuration((String)snapshotFrequency, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (Exception e) {
            txTtlSec = (int)FormatUtils.getTimeDuration((String)"30 secs", (TimeUnit)TimeUnit.SECONDS);
            logger.warn("Failed to parse {} due to {}, use default as {} secs.", new Object[]{"nifi.remote.input.http.transaction.ttl", e.getMessage(), txTtlSec});
        }
        this.transactionTtlSec = txTtlSec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpRemoteSiteListener getInstance(NiFiProperties nifiProperties) {
        if (instance != null) return instance;
        Class<HttpRemoteSiteListener> clazz = HttpRemoteSiteListener.class;
        synchronized (HttpRemoteSiteListener.class) {
            if (instance != null) return instance;
            instance = new HttpRemoteSiteListener(nifiProperties);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void setRootGroup(ProcessGroup rootGroup) {
        this.rootGroup = rootGroup;
    }

    public void setupServerProtocol(HttpFlowFileServerProtocol serverProtocol) {
        serverProtocol.setRootProcessGroup(this.rootGroup);
    }

    @Override
    public void start() {
        this.transactionMaintenanceTask = this.taskExecutor.scheduleWithFixedDelay(() -> {
            int originalSize = this.transactions.size();
            logger.trace("Transaction maintenance task started.");
            try {
                for (String transactionId : this.transactions.keySet()) {
                    if (this.isTransactionActive(transactionId)) continue;
                    this.cancelTransaction(transactionId);
                }
            }
            catch (Exception e) {
                logger.error("An exception occurred while maintaining transactions", (Throwable)e);
            }
            logger.debug("Transaction maintenance task finished. originalSize={}, currentSize={}", (Object)originalSize, (Object)this.transactions.size());
        }, 0L, this.transactionTtlSec / 2, TimeUnit.SECONDS);
    }

    public void cancelTransaction(String transactionId) {
        TransactionWrapper wrapper = this.transactions.remove(transactionId);
        if (wrapper == null) {
            logger.debug("The transaction was not found. transactionId={}", (Object)transactionId);
        } else {
            logger.debug("Cancel a transaction. transactionId={}", (Object)transactionId);
            FlowFileTransaction t = wrapper.transaction;
            if (t != null && t.getSession() != null) {
                logger.info("Cancel a transaction, rollback its session. transactionId={}", (Object)transactionId);
                try {
                    t.getSession().rollback();
                }
                catch (Exception e) {
                    logger.error("Failed to rollback. transactionId={}", (Object)transactionId, (Object)e);
                }
            }
        }
    }

    @Override
    public void stop() {
        if (this.taskExecutor != null) {
            logger.debug("Stopping Http Site-to-Site Transaction Maintenance task...");
            this.taskExecutor.shutdown();
        }
        if (this.transactionMaintenanceTask != null) {
            logger.debug("Stopping transactionMaintenanceTask...");
            this.transactionMaintenanceTask.cancel(true);
        }
    }

    @Override
    public void destroy() {
        this.stop();
        instance = null;
    }

    public String createTransaction() {
        String transactionId = UUID.randomUUID().toString();
        this.transactions.put(transactionId, new TransactionWrapper(null, null));
        logger.debug("Created a new transaction: {}", (Object)transactionId);
        return transactionId;
    }

    public boolean isTransactionActive(String transactionId) {
        TransactionWrapper transaction = this.transactions.get(transactionId);
        return this.isTransactionActive(transaction);
    }

    private boolean isTransactionActive(TransactionWrapper transaction) {
        if (transaction == null) {
            return false;
        }
        return !transaction.isExpired();
    }

    public HandshakeProperties getHandshakenProperties(String transactionId) {
        TransactionWrapper transaction = this.transactions.get(transactionId);
        if (this.isTransactionActive(transaction)) {
            return transaction.handshakeProperties;
        }
        return null;
    }

    public void holdTransaction(String transactionId, FlowFileTransaction transaction, HandshakeProperties handshakenProperties) throws IllegalStateException {
        TransactionWrapper currentTransaction = this.transactions.remove(transactionId);
        if (currentTransaction == null) {
            logger.debug("The transaction was not found, it looks it took longer than transaction TTL.");
        } else if (currentTransaction.transaction != null) {
            throw new IllegalStateException("Transaction has already been processed. It can only be finalized. transactionId=" + transactionId);
        }
        if (transaction.getSession() == null) {
            throw new IllegalStateException("Passed transaction is not associated any session yet, can not hold. transactionId=" + transactionId);
        }
        logger.debug("Holding a transaction: {}", (Object)transactionId);
        this.transactions.put(transactionId, new TransactionWrapper(transaction, handshakenProperties));
    }

    public FlowFileTransaction finalizeTransaction(String transactionId) throws IllegalStateException {
        if (!this.isTransactionActive(transactionId)) {
            throw new IllegalStateException("Transaction was not found or not active anymore. transactionId=" + transactionId);
        }
        TransactionWrapper transaction = this.transactions.remove(transactionId);
        if (transaction == null) {
            throw new IllegalStateException("Transaction was not found anymore. It's already finalized or expired. transactionId=" + transactionId);
        }
        if (transaction.transaction == null) {
            throw new IllegalStateException("Transaction has not started yet.");
        }
        logger.debug("Finalized a transaction: {}", (Object)transactionId);
        return transaction.transaction;
    }

    public void extendTransaction(String transactionId) throws IllegalStateException {
        if (!this.isTransactionActive(transactionId)) {
            throw new IllegalStateException("Transaction was not found or not active anymore. transactionId=" + transactionId);
        }
        TransactionWrapper transaction = this.transactions.get(transactionId);
        if (transaction != null) {
            logger.debug("Extending transaction TTL, transactionId={}", (Object)transactionId);
            transaction.extend();
        }
    }

    public int getTransactionTtlSec() {
        return this.transactionTtlSec;
    }

    private class TransactionWrapper {
        private final FlowFileTransaction transaction;
        private final HandshakeProperties handshakeProperties;
        private long lastCommunicationAt;

        private TransactionWrapper(FlowFileTransaction transaction, HandshakeProperties handshakeProperties) {
            this.transaction = transaction;
            this.handshakeProperties = handshakeProperties;
            this.lastCommunicationAt = System.currentTimeMillis();
        }

        private boolean isExpired() {
            long elapsedMillis = System.currentTimeMillis() - this.lastCommunicationAt;
            long elapsedSec = TimeUnit.SECONDS.convert(elapsedMillis, TimeUnit.MILLISECONDS);
            return elapsedSec > (long)HttpRemoteSiteListener.this.transactionTtlSec;
        }

        private void extend() {
            this.lastCommunicationAt = System.currentTimeMillis();
        }
    }
}

