/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.toolkit.configuration;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.nifi.minifi.commons.schema.ConfigSchema;
import org.apache.nifi.minifi.commons.schema.common.ConvertableSchema;
import org.apache.nifi.minifi.commons.schema.exception.SchemaLoaderException;
import org.apache.nifi.minifi.commons.schema.serialization.SchemaLoader;
import org.apache.nifi.minifi.commons.schema.serialization.SchemaSaver;
import org.apache.nifi.minifi.toolkit.configuration.PathInputStreamFactory;
import org.apache.nifi.minifi.toolkit.configuration.PathOutputStreamFactory;
import org.apache.nifi.minifi.toolkit.configuration.dto.ConfigSchemaFunction;
import org.apache.nifi.minifi.toolkit.configuration.dto.FlowSnippetDTOEnricher;
import org.apache.nifi.minifi.toolkit.configuration.registry.NiFiRegConfigSchemaFunction;
import org.apache.nifi.minifi.toolkit.configuration.registry.VersionedProcessGroupEnricher;
import org.apache.nifi.registry.flow.VersionedFlowSnapshot;
import org.apache.nifi.web.api.dto.TemplateDTO;

public class ConfigMain {
    public static final int ERR_INVALID_ARGS = 1;
    public static final int ERR_UNABLE_TO_OPEN_OUTPUT = 2;
    public static final int ERR_UNABLE_TO_OPEN_INPUT = 3;
    public static final int ERR_UNABLE_TO_READ_TEMPLATE = 4;
    public static final int ERR_UNABLE_TO_PARSE_CONFIG = 6;
    public static final int ERR_INVALID_CONFIG = 7;
    public static final int ERR_UNABLE_TO_CLOSE_CONFIG = 8;
    public static final int ERR_UNABLE_TO_SAVE_CONFIG = 9;
    public static final int SUCCESS = 0;
    public static final String TRANSFORM = "transform";
    public static final String TRANSFORM_VFS = "transform-vfs";
    public static final String VALIDATE = "validate";
    public static final String UPGRADE = "upgrade";
    public static final String THERE_ARE_VALIDATION_ERRORS_WITH_THE_TEMPLATE_STILL_OUTPUTTING_YAML_BUT_IT_WILL_NEED_TO_BE_EDITED = "There are validation errors with the template, still outputting YAML but it will need to be edited.";
    private final Map<String, Command> commandMap;
    private final PathInputStreamFactory pathInputStreamFactory;
    private final PathOutputStreamFactory pathOutputStreamFactory;

    public ConfigMain() {
        this(FileInputStream::new, FileOutputStream::new);
    }

    public ConfigMain(PathInputStreamFactory pathInputStreamFactory, PathOutputStreamFactory pathOutputStreamFactory) {
        this.pathInputStreamFactory = pathInputStreamFactory;
        this.pathOutputStreamFactory = pathOutputStreamFactory;
        this.commandMap = this.createCommandMap();
    }

    public static void main(String[] args) {
        System.exit(new ConfigMain().execute(args));
    }

    public static void printValidateUsage() {
        System.out.println("Validate Usage:");
        System.out.println();
        System.out.println(" validate INPUT_FILE");
        System.out.println();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int validate(String[] args) {
        if (args.length != 2) {
            ConfigMain.printValidateUsage();
            return 1;
        }
        try {
            Throwable throwable = null;
            try (InputStream inputStream = this.pathInputStreamFactory.create(args[1]);){
                int n = this.loadAndPrintValidationErrors(inputStream, (configSchema, valid) -> {
                    if (valid.booleanValue()) {
                        return 0;
                    }
                    return 7;
                });
                return n;
            }
            catch (IOException | SchemaLoaderException e) {
                int n2 = this.handleErrorLoadingConfiguration((Exception)e, ConfigMain::printValidateUsage);
                return n2;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
        }
        catch (FileNotFoundException e2) {
            return this.handleErrorOpeningInput(args[1], ConfigMain::printValidateUsage, e2);
        }
        catch (IOException e3) {
            this.handleErrorClosingInput(e3);
            return 8;
        }
    }

    public static void printTransformUsage() {
        System.out.println("Transform Usage:");
        System.out.println();
        System.out.println(" transform INPUT_FILE OUTPUT_FILE");
        System.out.println();
    }

    public static void printUpgradeUsage() {
        System.out.println("Upgrade Usage:");
        System.out.println();
        System.out.println(" upgrade INPUT_FILE OUTPUT_FILE");
        System.out.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigSchema transformTemplateToSchema(InputStream source) throws JAXBException, IOException {
        try {
            ConfigSchema configSchema;
            TemplateDTO templateDTO = (TemplateDTO)JAXBContext.newInstance((Class[])new Class[]{TemplateDTO.class}).createUnmarshaller().unmarshal(source);
            FlowSnippetDTOEnricher enricher = new FlowSnippetDTOEnricher();
            enricher.enrich(templateDTO.getSnippet(), templateDTO.getEncodingVersion());
            ConfigSchema configSchema2 = configSchema = new ConfigSchemaFunction().apply(templateDTO);
            return configSchema2;
        }
        finally {
            source.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigSchema transformVersionedFlowSnapshotToSchema(InputStream source) throws IOException {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            objectMapper.setAnnotationIntrospector((AnnotationIntrospector)new JaxbAnnotationIntrospector(objectMapper.getTypeFactory()));
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            VersionedFlowSnapshot versionedFlowSnapshot = (VersionedFlowSnapshot)objectMapper.readValue(source, VersionedFlowSnapshot.class);
            ConfigSchema configSchema = ConfigMain.transformVersionedFlowSnapshotToSchema(versionedFlowSnapshot);
            return configSchema;
        }
        finally {
            source.close();
        }
    }

    public static ConfigSchema transformVersionedFlowSnapshotToSchema(VersionedFlowSnapshot versionedFlowSnapshot) {
        VersionedProcessGroupEnricher enricher = new VersionedProcessGroupEnricher();
        enricher.enrich(versionedFlowSnapshot.getFlowContents());
        ConfigSchema configSchema = new NiFiRegConfigSchemaFunction().apply(versionedFlowSnapshot);
        return configSchema;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int upgrade(String[] args) {
        Throwable throwable;
        if (args.length != 3) {
            ConfigMain.printUpgradeUsage();
            return 1;
        }
        ConfigSchema currentSchema = null;
        try {
            throwable = null;
            try (InputStream inputStream = this.pathInputStreamFactory.create(args[1]);){
                try {
                    currentSchema = this.loadAndPrintValidationErrors(inputStream, (configSchema, valid) -> {
                        if (!valid.booleanValue()) {
                            System.out.println(THERE_ARE_VALIDATION_ERRORS_WITH_THE_TEMPLATE_STILL_OUTPUTTING_YAML_BUT_IT_WILL_NEED_TO_BE_EDITED);
                            System.out.println();
                        }
                        return configSchema;
                    });
                }
                catch (IOException | SchemaLoaderException e) {
                    int n = this.handleErrorLoadingConfiguration((Exception)e, ConfigMain::printUpgradeUsage);
                    if (inputStream == null) return n;
                    if (throwable == null) {
                        inputStream.close();
                        return n;
                    }
                    try {
                        inputStream.close();
                        return n;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                        return n;
                    }
                }
            }
            catch (Throwable e) {
                throwable = e;
                throw e;
            }
        }
        catch (FileNotFoundException e) {
            return this.handleErrorOpeningInput(args[1], ConfigMain::printUpgradeUsage, e);
        }
        catch (IOException e) {
            this.handleErrorClosingInput(e);
        }
        try {
            throwable = null;
            try (OutputStream fileOutputStream = this.pathOutputStreamFactory.create(args[2]);){
                try {
                    SchemaSaver.saveConfigSchema((ConfigSchema)currentSchema, (OutputStream)fileOutputStream);
                    return 0;
                }
                catch (IOException e) {
                    int n = this.handleErrorSavingCofiguration(e);
                    if (fileOutputStream == null) return n;
                    if (throwable != null) {
                        try {
                            fileOutputStream.close();
                            return n;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            return n;
                        }
                    }
                    fileOutputStream.close();
                    return n;
                }
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
        }
        catch (FileNotFoundException e) {
            return this.handleErrorOpeningOutput(args[2], ConfigMain::printUpgradeUsage, e);
        }
        catch (IOException e) {
            this.handleErrorClosingOutput(e);
        }
        return 0;
    }

    public <T> T loadAndPrintValidationErrors(InputStream inputStream, BiFunction<ConfigSchema, Boolean, T> resultHandler) throws IOException, SchemaLoaderException {
        ConvertableSchema configSchema = SchemaLoader.loadConvertableSchemaFromYaml((InputStream)inputStream);
        boolean valid = true;
        if (!configSchema.isValid()) {
            System.out.println("Found the following errors when parsing the configuration according to its version. (" + configSchema.getVersion() + ")");
            configSchema.getValidationIssues().forEach(s -> System.out.println((String)s));
            System.out.println();
            valid = false;
            configSchema.clearValidationIssues();
        } else {
            System.out.println("No errors found when parsing configuration according to its version. (" + configSchema.getVersion() + ")");
        }
        ConfigSchema currentSchema = (ConfigSchema)configSchema.convert();
        if (!currentSchema.isValid()) {
            System.out.println("Found the following errors when converting configuration to latest version. (3)");
            currentSchema.getValidationIssues().forEach(s -> System.out.println((String)s));
            System.out.println();
            valid = false;
        } else if (configSchema.getVersion() == currentSchema.getVersion()) {
            System.out.println("Configuration was already latest version (3) so no conversion was needed.");
        } else {
            System.out.println("No errors found when converting configuration to latest version. (3)");
        }
        return resultHandler.apply(currentSchema, valid);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int transform(String[] args) {
        Throwable throwable;
        if (args.length != 3) {
            ConfigMain.printTransformUsage();
            return 1;
        }
        ConfigSchema configSchema = null;
        try {
            throwable = null;
            try (InputStream inputStream = this.pathInputStreamFactory.create(args[1]);){
                try {
                    configSchema = TRANSFORM_VFS.equals(args[0]) ? ConfigMain.transformVersionedFlowSnapshotToSchema(inputStream) : ConfigMain.transformTemplateToSchema(inputStream);
                    if (!configSchema.isValid()) {
                        System.out.println(THERE_ARE_VALIDATION_ERRORS_WITH_THE_TEMPLATE_STILL_OUTPUTTING_YAML_BUT_IT_WILL_NEED_TO_BE_EDITED);
                        configSchema.getValidationIssues().forEach(System.out::println);
                        System.out.println();
                    } else {
                        System.out.println("No validation errors found in converted configuration.");
                    }
                }
                catch (JAXBException e) {
                    System.out.println("Error reading template. (" + (Object)((Object)e) + ")");
                    System.out.println();
                    ConfigMain.printTransformUsage();
                    int n = 4;
                    if (inputStream == null) return n;
                    if (throwable == null) {
                        inputStream.close();
                        return n;
                    }
                    try {
                        inputStream.close();
                        return n;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                        return n;
                    }
                }
            }
            catch (Throwable e) {
                throwable = e;
                throw e;
            }
        }
        catch (FileNotFoundException e) {
            return this.handleErrorOpeningInput(args[1], ConfigMain::printTransformUsage, e);
        }
        catch (IOException e) {
            this.handleErrorClosingInput(e);
        }
        try {
            throwable = null;
            try (OutputStream fileOutputStream = this.pathOutputStreamFactory.create(args[2]);){
                try {
                    SchemaSaver.saveConfigSchema((ConfigSchema)configSchema, (OutputStream)fileOutputStream);
                    return 0;
                }
                catch (IOException e) {
                    int n = this.handleErrorSavingCofiguration(e);
                    if (fileOutputStream == null) return n;
                    if (throwable != null) {
                        try {
                            fileOutputStream.close();
                            return n;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            return n;
                        }
                    }
                    fileOutputStream.close();
                    return n;
                }
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
        }
        catch (FileNotFoundException e) {
            return this.handleErrorOpeningOutput(args[2], ConfigMain::printTransformUsage, e);
        }
        catch (IOException e) {
            this.handleErrorClosingOutput(e);
        }
        return 0;
    }

    protected void handleErrorClosingOutput(IOException e) {
        System.out.println("Error closing output. (" + e + ")");
        System.out.println();
    }

    protected void handleErrorClosingInput(IOException e) {
        System.out.println("Error closing input. (" + e + ")");
        System.out.println();
    }

    protected int handleErrorOpeningInput(String fileName, Runnable usagePrinter, FileNotFoundException e) {
        System.out.println("Unable to open file " + fileName + " for reading. (" + e + ")");
        System.out.println();
        usagePrinter.run();
        return 3;
    }

    protected int handleErrorOpeningOutput(String fileName, Runnable usagePrinter, FileNotFoundException e) {
        System.out.println("Unable to open file " + fileName + " for writing. (" + e + ")");
        System.out.println();
        usagePrinter.run();
        return 2;
    }

    protected int handleErrorLoadingConfiguration(Exception e, Runnable usagePrinter) {
        System.out.println("Unable to load configuration. (" + e + ")");
        System.out.println();
        usagePrinter.run();
        return 6;
    }

    protected int handleErrorSavingCofiguration(IOException e) {
        System.out.println("Unable to save configuration: " + e);
        System.out.println();
        return 9;
    }

    public int execute(String[] args) {
        if (args.length < 1 || !this.commandMap.containsKey(args[0].toLowerCase())) {
            this.printUsage();
            return 1;
        }
        return (Integer)this.commandMap.get(args[0].toLowerCase()).function.apply(args);
    }

    public Map<String, Command> createCommandMap() {
        TreeMap<String, Command> result = new TreeMap<String, Command>();
        result.put(TRANSFORM, new Command(this::transform, "Transform template xml into MiNiFi config YAML"));
        result.put(TRANSFORM_VFS, new Command(this::transform, "Transform VersionedFlowSnapshot JSON into MiNiFi config YAML"));
        result.put(VALIDATE, new Command(this::validate, "Validate config YAML"));
        result.put(UPGRADE, new Command(this::upgrade, "Upgrade config YAML to current version (3)"));
        return result;
    }

    public void printUsage() {
        System.out.println("Usage:");
        System.out.println();
        System.out.println("Valid commands include:");
        this.commandMap.forEach((s, command) -> System.out.println(s + ": " + ((Command)command).description));
    }

    public class Command {
        private final Function<String[], Integer> function;
        private final String description;

        public Command(Function<String[], Integer> function, String description) {
            this.function = function;
            this.description = description;
        }
    }
}

