/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.network;

import io.questdb.network.NetworkError;
import io.questdb.std.Chars;
import io.questdb.std.Files;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.Path;
import io.questdb.std.str.StdoutSink;
import java.util.concurrent.atomic.AtomicInteger;

public final class Net {
    public static final int EOTHERDISCONNECT = -2;
    public static final int EPEERDISCONNECT = -1;
    public static final int ERETRY = 0;
    public static final int EWOULDBLOCK;
    public static final long MMSGHDR_BUFFER_ADDRESS_OFFSET;
    public static final long MMSGHDR_BUFFER_LENGTH_OFFSET;
    public static final long MMSGHDR_SIZE;
    public static final int SHUT_WR = 1;
    private static final AtomicInteger ADDR_INFO_COUNTER;
    private static final AtomicInteger SOCK_ADDR_COUNTER;

    private Net() {
    }

    public static native int abortAccept(int var0);

    public static int accept(int serverFd) {
        return Files.bumpFileCount(Net.accept0(serverFd));
    }

    public static void appendIP4(CharSink sink, long ip) {
        sink.put(ip >> 24 & 0xFFL).put('.').put(ip >> 16 & 0xFFL).put('.').put(ip >> 8 & 0xFFL).put('.').put(ip & 0xFFL);
    }

    public static native boolean bindTcp(int var0, int var1, int var2);

    public static boolean bindTcp(int fd, CharSequence ipv4address, int port) {
        return Net.bindTcp(fd, Net.parseIPv4(ipv4address), port);
    }

    public static native boolean bindUdp(int var0, int var1, int var2);

    public static void bumpFdCount(int fd) {
        Files.bumpFileCount(fd);
    }

    public static int close(int fd) {
        return Files.close(fd);
    }

    public static native int configureLinger(int var0, int var1);

    public static int configureNoLinger(int fd) {
        return Net.configureLinger(fd, 0);
    }

    public static native int configureNonBlocking(int var0);

    public static native int connect(int var0, long var1);

    public static native int connectAddrInfo(int var0, long var1);

    public static void dump(long buffer, int len) {
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                Numbers.appendHex(StdoutSink.INSTANCE, Unsafe.getUnsafe().getByte(buffer + (long)i) & 0xFF);
            }
            StdoutSink.INSTANCE.put('\n');
            StdoutSink.INSTANCE.flush();
        }
    }

    public static void freeAddrInfo(long pAddrInfo) {
        if (pAddrInfo != 0L) {
            ADDR_INFO_COUNTER.decrementAndGet();
        }
        Net.freeAddrInfo0(pAddrInfo);
    }

    public static native void freeMsgHeaders(long var0);

    public static void freeSockAddr(long sockaddr) {
        if (sockaddr != 0L) {
            SOCK_ADDR_COUNTER.decrementAndGet();
        }
        Net.freeSockAddr0(sockaddr);
    }

    public static long getAddrInfo(LPSZ host, int port) {
        return Net.getAddrInfo(host.address(), port);
    }

    public static long getAddrInfo(CharSequence host, int port) {
        try (Path p = new Path().of(host).$();){
            long l = Net.getAddrInfo(p, port);
            return l;
        }
    }

    public static long getAddrInfo(long lpszHost, int port) {
        long addrInfo = Net.getAddrInfo0(lpszHost, port);
        if (addrInfo != -1L) {
            ADDR_INFO_COUNTER.incrementAndGet();
        }
        return addrInfo;
    }

    public static int getAllocatedAddrInfoCount() {
        return ADDR_INFO_COUNTER.get();
    }

    public static int getAllocatedSockAddrCount() {
        return SOCK_ADDR_COUNTER.get();
    }

    public static long getMMsgBuf(long msgPtr) {
        return Unsafe.getUnsafe().getLong(Unsafe.getUnsafe().getLong(msgPtr + MMSGHDR_BUFFER_ADDRESS_OFFSET));
    }

    public static int getMMsgBufLen(long msgPtr) {
        return Unsafe.getUnsafe().getInt(msgPtr + MMSGHDR_BUFFER_LENGTH_OFFSET);
    }

    public static native int getPeerIP(int var0);

    public static native int getPeerPort(int var0);

    public static native int getRcvBuf(int var0);

    public static native int getSndBuf(int var0);

    public static native int getTcpNoDelay(int var0);

    public static native boolean isDead(int var0);

    public static boolean join(int fd, CharSequence bindIPv4Address, CharSequence groupIPv4Address) {
        return Net.join(fd, Net.parseIPv4(bindIPv4Address), Net.parseIPv4(groupIPv4Address));
    }

    public static native boolean join(int var0, int var1, int var2);

    public static native void listen(int var0, int var1);

    public static native long msgHeaders(int var0, int var1);

    public static int parseIPv4(CharSequence ipv4Address) {
        int ip = 0;
        int count = 0;
        int lo = 0;
        try {
            int hi;
            while ((hi = Chars.indexOf(ipv4Address, lo, '.')) > -1) {
                int n = Numbers.parseInt(ipv4Address, lo, hi);
                ip = ip << 8 | n;
                ++count;
                lo = hi + 1;
            }
            if (count != 3) {
                throw NetworkError.instance(0, "invalid address [").put(ipv4Address).put(']');
            }
            return ip << 8 | Numbers.parseInt(ipv4Address, lo, ipv4Address.length());
        }
        catch (NumericException e) {
            throw NetworkError.instance(0, "invalid address [").put(ipv4Address).put(']');
        }
    }

    public static native int peek(int var0, long var1, int var3);

    public static native int recv(int var0, long var1, int var3);

    public static native int recvmmsg(int var0, long var1, int var3);

    public static native int resolvePort(int var0);

    public static native int send(int var0, long var1, int var3);

    public static native int sendTo(int var0, long var1, int var3, long var4);

    public static native int setMulticastInterface(int var0, int var1);

    public static native int setMulticastLoop(int var0, boolean var1);

    public static native int setMulticastTtl(int var0, int var1);

    public static native int setRcvBuf(int var0, int var1);

    public static native int setReuseAddress(int var0);

    public static native int setReusePort(int var0);

    public static native int setSndBuf(int var0, int var1);

    public static native int setTcpNoDelay(int var0, boolean var1);

    public static native int shutdown(int var0, int var1);

    public static long sockaddr(CharSequence ipv4address, int port) {
        return Net.sockaddr(Net.parseIPv4(ipv4address), port);
    }

    public static long sockaddr(int ipv4address, int port) {
        SOCK_ADDR_COUNTER.incrementAndGet();
        return Net.sockaddr0(ipv4address, port);
    }

    public static int socketTcp(boolean blocking) {
        return Files.bumpFileCount(Net.socketTcp0(blocking));
    }

    public static int socketUdp() {
        return Files.bumpFileCount(Net.socketUdp0());
    }

    private static native int accept0(int var0);

    private static native void freeAddrInfo0(long var0);

    private static native void freeSockAddr0(long var0);

    private static native long getAddrInfo0(long var0, int var2);

    private static native int getEwouldblock();

    private static native long getMsgHeaderBufferAddressOffset();

    private static native long getMsgHeaderBufferLengthOffset();

    private static native long getMsgHeaderSize();

    private static native long sockaddr0(int var0, int var1);

    private static native int socketTcp0(boolean var0);

    private static native int socketUdp0();

    static {
        ADDR_INFO_COUNTER = new AtomicInteger();
        SOCK_ADDR_COUNTER = new AtomicInteger();
        Os.init();
        EWOULDBLOCK = Net.getEwouldblock();
        if (Os.isLinux()) {
            MMSGHDR_SIZE = Net.getMsgHeaderSize();
            MMSGHDR_BUFFER_ADDRESS_OFFSET = Net.getMsgHeaderBufferAddressOffset();
            MMSGHDR_BUFFER_LENGTH_OFFSET = Net.getMsgHeaderBufferLengthOffset();
        } else {
            MMSGHDR_SIZE = -1L;
            MMSGHDR_BUFFER_ADDRESS_OFFSET = -1L;
            MMSGHDR_BUFFER_LENGTH_OFFSET = -1L;
        }
    }
}

