/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.mp;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;

public class SimpleWaitingLock {
    private final AtomicBoolean lock = new AtomicBoolean(false);
    private volatile Thread waiter = null;

    public boolean isLocked() {
        return this.lock.get();
    }

    public void lock() {
        this.waiter = Thread.currentThread();
        while (true) {
            if (this.lock.get()) {
                LockSupport.park();
                continue;
            }
            if (!this.lock.getAndSet(true)) break;
        }
    }

    public boolean tryLock(long timeout, TimeUnit unit) {
        block3: {
            if (this.tryLock()) {
                return true;
            }
            if (timeout <= 0L) {
                return false;
            }
            long nanos = unit.toNanos(timeout);
            this.waiter = Thread.currentThread();
            do {
                long start = System.nanoTime();
                LockSupport.parkNanos(nanos);
                long elapsed = System.nanoTime() - start;
                if (elapsed >= nanos) break block3;
            } while (!this.tryLock());
            return true;
        }
        return false;
    }

    public boolean tryLock() {
        return this.lock.compareAndSet(false, true);
    }

    public void unlock() {
        if (this.lock.compareAndSet(true, false)) {
            Thread waiter = this.waiter;
            this.waiter = null;
            if (waiter != null) {
                LockSupport.unpark(waiter);
            }
        } else {
            throw new IllegalStateException();
        }
    }
}

