/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.commons.schema.common;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CollectionOverlap<T> {
    private final Set<T> elements;
    private final Set<T> duplicates;

    public CollectionOverlap(Collection<T> ... collections) {
        this(Arrays.stream(collections).map(c -> c.stream()));
    }

    public CollectionOverlap(Stream<T> ... streams) {
        this(Arrays.stream(streams).map(Function.identity()));
    }

    public CollectionOverlap(Stream<Stream<T>> streams) {
        HashSet elements = new HashSet();
        this.duplicates = Collections.unmodifiableSet(((Stream)streams.flatMap(Function.identity()).sequential()).filter(s -> !elements.add(s)).collect(Collectors.toSet()));
        this.elements = Collections.unmodifiableSet(elements);
    }

    public Set<T> getElements() {
        return this.elements;
    }

    public Set<T> getDuplicates() {
        return this.duplicates;
    }
}

