/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.repository.encryption.metadata.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import org.apache.nifi.repository.encryption.metadata.RecordMetadata;
import org.apache.nifi.repository.encryption.metadata.RecordMetadataReader;
import org.apache.nifi.repository.encryption.metadata.serialization.SerializableRecordMetadata;
import org.apache.nifi.repository.encryption.metadata.serialization.StandardRecordMetadata;

public class RecordMetadataObjectInputStream
extends ObjectInputStream
implements RecordMetadataReader {
    private static final String METADATA_PACKAGE_NAME = "org.apache.nifi";

    public RecordMetadataObjectInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    @Override
    public RecordMetadata getRecordMetadata() throws IOException {
        try {
            return (RecordMetadata)this.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Metadata Class not found", e);
        }
    }

    @Override
    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        ObjectStreamClass classDescriptor = super.readClassDescriptor();
        String name = classDescriptor.getName();
        if (name.startsWith(METADATA_PACKAGE_NAME)) {
            classDescriptor = classDescriptor.getFields().length == 0 ? ObjectStreamClass.lookup(StandardRecordMetadata.class) : ObjectStreamClass.lookup(SerializableRecordMetadata.class);
        }
        return classDescriptor;
    }
}

