/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.std.Chars;
import io.questdb.std.LowerCaseCharSequenceHashSet;

public class SqlKeywords {
    public static final int CASE_KEYWORD_LENGTH = 4;
    public static final String CONCAT_FUNC_NAME = "concat";
    public static final int GEOHASH_KEYWORD_LENGTH = 7;
    private static final LowerCaseCharSequenceHashSet TIMESTAMP_PART_SET = new LowerCaseCharSequenceHashSet();

    public static boolean isAddKeyword(CharSequence tok) {
        if (tok.length() != 3) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 100 && (tok.charAt(i) | 0x20) == 100;
    }

    public static boolean isAlignKeyword(CharSequence tok) {
        if (tok.length() != 5) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 108 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 103 && (tok.charAt(i) | 0x20) == 110;
    }

    public static boolean isAllKeyword(CharSequence tok) {
        if (tok.length() != 3) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 108 && (tok.charAt(i) | 0x20) == 108;
    }

    public static boolean isAlterKeyword(CharSequence tok) {
        if (tok.length() != 5) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 108 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i) | 0x20) == 114;
    }

    public static boolean isAndKeyword(CharSequence tok) {
        if (tok.length() != 3) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 110 && (tok.charAt(i) | 0x20) == 100;
    }

    public static boolean isAsKeyword(CharSequence tok) {
        if (tok.length() != 2) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i) | 0x20) == 115;
    }

    public static boolean isAscKeyword(CharSequence tok) {
        if (tok.length() != 3) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 115 && (tok.charAt(i) | 0x20) == 99;
    }

    public static boolean isAtKeyword(CharSequence tok) {
        if (tok.length() != 2) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i) | 0x20) == 116;
    }

    public static boolean isAttachKeyword(CharSequence tok) {
        if (tok.length() != 6) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 99 && (tok.charAt(i) | 0x20) == 104;
    }

    public static boolean isBatchKeyword(CharSequence tok) {
        if (tok.length() != 5) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 98 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 99 && (tok.charAt(i) | 0x20) == 104;
    }

    public static boolean isBetweenKeyword(CharSequence tok) {
        if (tok.length() != 7) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 98 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 119 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i) | 0x20) == 110;
    }

    public static boolean isByKeyword(CharSequence tok) {
        if (tok.length() != 2) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 98 && (tok.charAt(i) | 0x20) == 121;
    }

    public static boolean isBypassKeyword(CharSequence tok) {
        if (tok.length() != 6) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 98 && (tok.charAt(i++) | 0x20) == 121 && (tok.charAt(i++) | 0x20) == 112 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 115 && (tok.charAt(i) | 0x20) == 115;
    }

    public static boolean isCacheKeyword(CharSequence tok) {
        if (tok.length() != 5) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 99 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 99 && (tok.charAt(i++) | 0x20) == 104 && (tok.charAt(i) | 0x20) == 101;
    }

    public static boolean isCalendarKeyword(CharSequence tok) {
        if (tok.length() != 8) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 99 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 108 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 110 && (tok.charAt(i++) | 0x20) == 100 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i) | 0x20) == 114;
    }

    public static boolean isCancelKeyword(CharSequence tok) {
        if (tok.length() != 6) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 99 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 110 && (tok.charAt(i++) | 0x20) == 99 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i) | 0x20) == 108;
    }

    public static boolean isCapacityKeyword(CharSequence tok) {
        if (tok.length() != 8) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 99 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 112 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 99 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i) | 0x20) == 121;
    }

    public static boolean isCaseKeyword(CharSequence tok) {
        if (tok.length() != 4) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 99 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 115 && (tok.charAt(i) | 0x20) == 101;
    }

    public static boolean isCastKeyword(CharSequence tok) {
        if (tok.length() != 4) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 99 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 115 && (tok.charAt(i) | 0x20) == 116;
    }

    public static boolean isCenturyKeyword(CharSequence tok) {
        if (tok.length() != 7) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 99 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 110 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 117 && (tok.charAt(i++) | 0x20) == 114 && (tok.charAt(i) | 0x20) == 121;
    }

    public static boolean isColonColon(CharSequence tok) {
        return tok.length() == 2 && tok.charAt(0) == ':' && tok.charAt(1) == ':';
    }

    public static boolean isColumnKeyword(CharSequence tok) {
        if (tok.length() != 6) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 99 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i++) | 0x20) == 108 && (tok.charAt(i++) | 0x20) == 117 && (tok.charAt(i++) | 0x20) == 109 && (tok.charAt(i) | 0x20) == 110;
    }

    public static boolean isColumnsKeyword(CharSequence tok) {
        if (tok.length() != 7) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 99 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i++) | 0x20) == 108 && (tok.charAt(i++) | 0x20) == 117 && (tok.charAt(i++) | 0x20) == 109 && (tok.charAt(i++) | 0x20) == 110 && (tok.charAt(i) | 0x20) == 115;
    }

    public static boolean isConcatKeyword(CharSequence tok) {
        if (tok.length() != 6) {
            return false;
        }
        if (tok == CONCAT_FUNC_NAME) {
            return true;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 99 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i++) | 0x20) == 110 && (tok.charAt(i++) | 0x20) == 99 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i) | 0x20) == 116;
    }

    public static boolean isConcatOperator(CharSequence tok) {
        if (tok.length() != 2) {
            return false;
        }
        int i = 0;
        return tok.charAt(i++) == '|' && tok.charAt(i) == '|';
    }

    public static boolean isCopyKeyword(CharSequence tok) {
        if (tok.length() != 4) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 99 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i++) | 0x20) == 112 && (tok.charAt(i) | 0x20) == 121;
    }

    public static boolean isCountKeyword(CharSequence tok) {
        if (tok.length() != 5) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 99 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i++) | 0x20) == 117 && (tok.charAt(i++) | 0x20) == 110 && (tok.charAt(i) | 0x20) == 116;
    }

    public static boolean isCreateKeyword(CharSequence tok) {
        if (tok.length() != 6) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 99 && (tok.charAt(i++) | 0x20) == 114 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i) | 0x20) == 101;
    }

    public static boolean isDatabaseKeyword(CharSequence tok) {
        if (tok.length() != 8) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 100 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 98 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 115 && (tok.charAt(i) | 0x20) == 101;
    }

    public static boolean isDateKeyword(CharSequence tok) {
        if (tok.length() != 4) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 100 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i) | 0x20) == 101;
    }

    public static boolean isDateStyleKeyword(CharSequence tok) {
        if (tok.length() != 9) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 100 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 115 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 121 && (tok.charAt(i++) | 0x20) == 108 && (tok.charAt(i) | 0x20) == 101;
    }

    public static boolean isDayKeyword(CharSequence tok) {
        if (tok.length() != 3) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 100 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i) | 0x20) == 121;
    }

    public static boolean isDecadeKeyword(CharSequence tok) {
        if (tok.length() != 6) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 100 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 99 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 100 && (tok.charAt(i) | 0x20) == 101;
    }

    public static boolean isDelimiterKeyword(CharSequence tok) {
        if (tok.length() != 9) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 100 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 108 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 109 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i) | 0x20) == 114;
    }

    public static boolean isDescKeyword(CharSequence tok) {
        if (tok.length() != 4) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 100 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 115 && (tok.charAt(i) | 0x20) == 99;
    }

    public static boolean isDetachKeyword(CharSequence tok) {
        if (tok.length() != 6) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 100 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 99 && (tok.charAt(i) | 0x20) == 104;
    }

    public static boolean isDistinctKeyword(CharSequence tok) {
        if (tok.length() != 8) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 100 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 115 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 110 && (tok.charAt(i++) | 0x20) == 99 && (tok.charAt(i) | 0x20) == 116;
    }

    public static boolean isDowKeyword(CharSequence tok) {
        if (tok.length() != 3) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 100 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i) | 0x20) == 119;
    }

    public static boolean isDoyKeyword(CharSequence tok) {
        if (tok.length() != 3) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 100 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i) | 0x20) == 121;
    }

    public static boolean isDropKeyword(CharSequence tok) {
        if (tok.length() != 4) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 100 && (tok.charAt(i++) | 0x20) == 114 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i) | 0x20) == 112;
    }

    public static boolean isEndKeyword(CharSequence tok) {
        if (tok.length() != 3) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 110 && (tok.charAt(i) | 0x20) == 100;
    }

    public static boolean isEpochKeyword(CharSequence tok) {
        if (tok.length() != 5) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 112 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i++) | 0x20) == 99 && (tok.charAt(i) | 0x20) == 104;
    }

    public static boolean isExceptKeyword(CharSequence tok) {
        if (tok.length() != 6) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 120 && (tok.charAt(i++) | 0x20) == 99 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 112 && (tok.charAt(i) | 0x20) == 116;
    }

    public static boolean isExclusiveKeyword(CharSequence tok) {
        if (tok.length() != 9) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 120 && (tok.charAt(i++) | 0x20) == 99 && (tok.charAt(i++) | 0x20) == 108 && (tok.charAt(i++) | 0x20) == 117 && (tok.charAt(i++) | 0x20) == 115 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 118 && (tok.charAt(i) | 0x20) == 101;
    }

    public static boolean isExistsKeyword(CharSequence tok) {
        if (tok.length() != 6) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 120 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 115 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i) | 0x20) == 115;
    }

    public static boolean isExplainKeyword(CharSequence tok) {
        if (tok.length() != 7) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 120 && (tok.charAt(i++) | 0x20) == 112 && (tok.charAt(i++) | 0x20) == 108 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i) | 0x20) == 110;
    }

    public static boolean isExtractKeyword(CharSequence tok) {
        if (tok.length() != 7) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 120 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 114 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 99 && (tok.charAt(i) | 0x20) == 116;
    }

    public static boolean isFalseKeyword(CharSequence tok) {
        if (tok.length() != 5) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 102 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 108 && (tok.charAt(i++) | 0x20) == 115 && (tok.charAt(i) | 0x20) == 101;
    }

    public static boolean isFillKeyword(CharSequence tok) {
        if (tok.length() != 4) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 102 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 108 && (tok.charAt(i) | 0x20) == 108;
    }

    public static boolean isFirstKeyword(CharSequence tok) {
        if (tok.length() != 5) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 102 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 114 && (tok.charAt(i++) | 0x20) == 115 && (tok.charAt(i) | 0x20) == 116;
    }

    public static boolean isFloat4Keyword(CharSequence tok) {
        if (tok.length() != 6) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 102 && (tok.charAt(i++) | 0x20) == 108 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 116 && tok.charAt(i) == '4';
    }

    public static boolean isFloat8Keyword(CharSequence tok) {
        if (tok.length() != 6) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 102 && (tok.charAt(i++) | 0x20) == 108 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 116 && tok.charAt(i) == '8';
    }

    public static boolean isFloatKeyword(CharSequence tok) {
        if (tok.length() != 5) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 102 && (tok.charAt(i++) | 0x20) == 108 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i) | 0x20) == 116;
    }

    public static boolean isFormatKeyword(CharSequence tok) {
        if (tok.length() != 6) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 102 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i++) | 0x20) == 114 && (tok.charAt(i++) | 0x20) == 109 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i) | 0x20) == 116;
    }

    public static boolean isFromKeyword(CharSequence tok) {
        if (tok.length() != 4) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 102 && (tok.charAt(i++) | 0x20) == 114 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i) | 0x20) == 109;
    }

    public static boolean isFullKeyword(CharSequence tok) {
        if (tok.length() != 4) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 102 && (tok.charAt(i++) | 0x20) == 117 && (tok.charAt(i++) | 0x20) == 108 && (tok.charAt(i) | 0x20) == 108;
    }

    public static boolean isGeoHashKeyword(CharSequence tok) {
        if (tok.length() != 7) {
            return false;
        }
        int i = 0;
        return SqlKeywords.isGeoHashKeyword(tok, i);
    }

    public static boolean isGroupKeyword(CharSequence tok) {
        if (tok.length() != 5) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 103 && (tok.charAt(i++) | 0x20) == 114 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i++) | 0x20) == 117 && (tok.charAt(i) | 0x20) == 112;
    }

    public static boolean isHeaderKeyword(CharSequence tok) {
        if (tok.length() != 6) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 104 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 100 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i) | 0x20) == 114;
    }

    public static boolean isHourKeyword(CharSequence tok) {
        if (tok.length() != 4) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 104 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i++) | 0x20) == 117 && (tok.charAt(i) | 0x20) == 114;
    }

    public static boolean isIfKeyword(CharSequence tok) {
        if (tok.length() != 2) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i) | 0x20) == 102;
    }

    public static boolean isInKeyword(CharSequence tok) {
        if (tok.length() != 2) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i) | 0x20) == 110;
    }

    public static boolean isIndexKeyword(CharSequence tok) {
        if (tok.length() != 5) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 110 && (tok.charAt(i++) | 0x20) == 100 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i) | 0x20) == 120;
    }

    public static boolean isInsertKeyword(CharSequence tok) {
        if (tok.length() != 6) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 110 && (tok.charAt(i++) | 0x20) == 115 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 114 && (tok.charAt(i) | 0x20) == 116;
    }

    public static boolean isIntersectKeyword(CharSequence tok) {
        if (tok.length() != 9) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 110 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 114 && (tok.charAt(i++) | 0x20) == 115 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 99 && (tok.charAt(i) | 0x20) == 116;
    }

    public static boolean isIntoKeyword(CharSequence tok) {
        if (tok.length() != 4) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 110 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i) | 0x20) == 111;
    }

    public static boolean isIsKeyword(CharSequence tok) {
        if (tok.length() != 2) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i) | 0x20) == 115;
    }

    public static boolean isIsoDowKeyword(CharSequence tok) {
        if (tok.length() != 6) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 115 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i++) | 0x20) == 100 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i) | 0x20) == 119;
    }

    public static boolean isIsoYearKeyword(CharSequence tok) {
        if (tok.length() != 7) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 115 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i++) | 0x20) == 121 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i) | 0x20) == 114;
    }

    public static boolean isIsolationKeyword(CharSequence tok) {
        if (tok.length() != 9) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 115 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i++) | 0x20) == 108 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i) | 0x20) == 110;
    }

    public static boolean isJsonKeyword(CharSequence tok) {
        if (tok.length() != 4) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 106 && (tok.charAt(i++) | 0x20) == 115 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i) | 0x20) == 110;
    }

    public static boolean isLastKeyword(CharSequence tok) {
        if (tok.length() != 4) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 108 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 115 && (tok.charAt(i) | 0x20) == 116;
    }

    public static boolean isLatestKeyword(CharSequence tok) {
        if (tok.length() != 6) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 108 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 115 && (tok.charAt(i) | 0x20) == 116;
    }

    public static boolean isLeftKeyword(CharSequence tok) {
        if (tok.length() != 4) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 108 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 102 && (tok.charAt(i) | 0x20) == 116;
    }

    public static boolean isLevelKeyword(CharSequence tok) {
        if (tok.length() != 5) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 108 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 118 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i) | 0x20) == 108;
    }

    public static boolean isLikeKeyword(CharSequence tok) {
        if (tok.length() != 4) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 108 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 107 && (tok.charAt(i) | 0x20) == 101;
    }

    public static boolean isLimitKeyword(CharSequence tok) {
        if (tok.length() != 5) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 108 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 109 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i) | 0x20) == 116;
    }

    public static boolean isLinearKeyword(CharSequence tok) {
        if (tok.length() != 6) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 108 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 110 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i) | 0x20) == 114;
    }

    public static boolean isListKeyword(CharSequence tok) {
        if (tok.length() != 4) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 108 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 115 && (tok.charAt(i) | 0x20) == 116;
    }

    public static boolean isLockKeyword(CharSequence tok) {
        if (tok.length() != 4) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 108 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i++) | 0x20) == 99 && (tok.charAt(i) | 0x20) == 107;
    }

    public static boolean isMaxIdentifierLength(CharSequence tok) {
        if (tok.length() != 21) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 109 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 120 && tok.charAt(i++) == '_' && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 100 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 110 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 102 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 114 && tok.charAt(i++) == '_' && (tok.charAt(i++) | 0x20) == 108 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 110 && (tok.charAt(i++) | 0x20) == 103 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i) | 0x20) == 104;
    }

    public static boolean isMaxUncommittedRowsKeyword(CharSequence tok) {
        if (tok.length() != 18) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 109 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 120 && (tok.charAt(i++) | 0x20) == 117 && (tok.charAt(i++) | 0x20) == 110 && (tok.charAt(i++) | 0x20) == 99 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i++) | 0x20) == 109 && (tok.charAt(i++) | 0x20) == 109 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 100 && (tok.charAt(i++) | 0x20) == 114 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i++) | 0x20) == 119 && (tok.charAt(i) | 0x20) == 115;
    }

    public static boolean isMicrosecondsKeyword(CharSequence tok) {
        if (tok.length() != 12) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 109 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 99 && (tok.charAt(i++) | 0x20) == 114 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i++) | 0x20) == 115 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 99 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i++) | 0x20) == 110 && (tok.charAt(i++) | 0x20) == 100 && (tok.charAt(i) | 0x20) == 115;
    }

    public static boolean isMillenniumKeyword(CharSequence tok) {
        if (tok.length() != 10) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 109 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 108 && (tok.charAt(i++) | 0x20) == 108 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 110 && (tok.charAt(i++) | 0x20) == 110 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 117 && (tok.charAt(i) | 0x20) == 109;
    }

    public static boolean isMillisecondsKeyword(CharSequence tok) {
        if (tok.length() != 12) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 109 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 108 && (tok.charAt(i++) | 0x20) == 108 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 115 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 99 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i++) | 0x20) == 110 && (tok.charAt(i++) | 0x20) == 100 && (tok.charAt(i) | 0x20) == 115;
    }

    public static boolean isMinuteKeyword(CharSequence tok) {
        if (tok.length() != 6) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 109 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 110 && (tok.charAt(i++) | 0x20) == 117 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i) | 0x20) == 101;
    }

    public static boolean isMonthKeyword(CharSequence tok) {
        if (tok.length() != 5) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 109 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i++) | 0x20) == 110 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i) | 0x20) == 104;
    }

    public static boolean isNanKeyword(CharSequence tok) {
        if (tok.length() != 3) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 110 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i) | 0x20) == 110;
    }

    public static boolean isNoCacheKeyword(CharSequence tok) {
        if (tok.length() != 7) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 110 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i++) | 0x20) == 99 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 99 && (tok.charAt(i++) | 0x20) == 104 && (tok.charAt(i) | 0x20) == 101;
    }

    public static boolean isNotJoinKeyword(CharSequence tok) {
        if (tok.length() != 4) {
            return true;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) != 106 || (tok.charAt(i++) | 0x20) != 111 || (tok.charAt(i++) | 0x20) != 105 || (tok.charAt(i) | 0x20) != 110;
    }

    public static boolean isNotKeyword(CharSequence tok) {
        if (tok.length() != 3) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 110 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i) | 0x20) == 116;
    }

    public static boolean isNullKeyword(CharSequence tok) {
        if (tok.length() != 4) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 110 && (tok.charAt(i++) | 0x20) == 117 && (tok.charAt(i++) | 0x20) == 108 && (tok.charAt(i) | 0x20) == 108;
    }

    public static boolean isO3MaxLagKeyword(CharSequence tok) {
        if (tok.length() != 8) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i++) | 0x20) == 51 && (tok.charAt(i++) | 0x20) == 109 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 120 && (tok.charAt(i++) | 0x20) == 108 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i) | 0x20) == 103;
    }

    public static boolean isObservationKeyword(CharSequence tok) {
        if (tok.length() != 11) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i++) | 0x20) == 98 && (tok.charAt(i++) | 0x20) == 115 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 114 && (tok.charAt(i++) | 0x20) == 118 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i) | 0x20) == 110;
    }

    public static boolean isOffsetKeyword(CharSequence tok) {
        if (tok.length() != 6) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i++) | 0x20) == 102 && (tok.charAt(i++) | 0x20) == 102 && (tok.charAt(i++) | 0x20) == 115 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i) | 0x20) == 116;
    }

    public static boolean isOnKeyword(CharSequence tok) {
        if (tok.length() != 2) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i) | 0x20) == 110;
    }

    public static boolean isOnlyKeyword(CharSequence tok) {
        if (tok.length() != 4) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i++) | 0x20) == 110 && (tok.charAt(i++) | 0x20) == 108 && (tok.charAt(i) | 0x20) == 121;
    }

    public static boolean isOrKeyword(CharSequence tok) {
        if (tok.length() != 2) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i) | 0x20) == 114;
    }

    public static boolean isOrderKeyword(CharSequence tok) {
        if (tok.length() != 5) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i++) | 0x20) == 114 && (tok.charAt(i++) | 0x20) == 100 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i) | 0x20) == 114;
    }

    public static boolean isOuterKeyword(CharSequence tok) {
        if (tok.length() != 5) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i++) | 0x20) == 117 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i) | 0x20) == 114;
    }

    public static boolean isOverKeyword(CharSequence tok) {
        if (tok.length() != 4) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i++) | 0x20) == 118 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i) | 0x20) == 114;
    }

    public static boolean isParamKeyword(CharSequence tok) {
        if (tok.length() != 5) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 112 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 114 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i) | 0x20) == 109;
    }

    public static boolean isPartitionKeyword(CharSequence tok) {
        if (tok.length() != 9) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 112 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 114 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i) | 0x20) == 110;
    }

    public static boolean isPartitionsKeyword(CharSequence tok) {
        if (tok.length() != 10) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 112 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 114 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i++) | 0x20) == 110 && (tok.charAt(i) | 0x20) == 115;
    }

    public static boolean isPrecisionKeyword(CharSequence tok) {
        if (tok.length() != 9) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 112 && (tok.charAt(i++) | 0x20) == 114 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 99 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 115 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i) | 0x20) == 110;
    }

    public static boolean isPrevKeyword(CharSequence tok) {
        if (tok.length() != 4) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 112 && (tok.charAt(i++) | 0x20) == 114 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i) | 0x20) == 118;
    }

    public static boolean isQuarterKeyword(CharSequence tok) {
        if (tok.length() != 7) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 113 && (tok.charAt(i++) | 0x20) == 117 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 114 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i) | 0x20) == 114;
    }

    public static boolean isQuote(CharSequence tok) {
        return tok.length() == 1 && tok.charAt(0) == '\'';
    }

    public static boolean isRenameKeyword(CharSequence tok) {
        if (tok.length() != 6) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 114 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 110 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 109 && (tok.charAt(i) | 0x20) == 101;
    }

    public static boolean isResumeKeyword(CharSequence tok) {
        if (tok.length() != 6) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 114 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 115 && (tok.charAt(i++) | 0x20) == 117 && (tok.charAt(i++) | 0x20) == 109 && (tok.charAt(i) | 0x20) == 101;
    }

    public static boolean isRightKeyword(CharSequence tok) {
        if (tok.length() != 5) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 114 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 103 && (tok.charAt(i++) | 0x20) == 104 && (tok.charAt(i) | 0x20) == 116;
    }

    public static boolean isSampleKeyword(CharSequence tok) {
        if (tok.length() != 6) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 115 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 109 && (tok.charAt(i++) | 0x20) == 112 && (tok.charAt(i++) | 0x20) == 108 && (tok.charAt(i) | 0x20) == 101;
    }

    public static boolean isSearchPath(CharSequence tok) {
        if (tok.length() != 11) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 115 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 114 && (tok.charAt(i++) | 0x20) == 99 && (tok.charAt(i++) | 0x20) == 104 && tok.charAt(i++) == '_' && (tok.charAt(i++) | 0x20) == 112 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i) | 0x20) == 104;
    }

    public static boolean isSecondKeyword(CharSequence tok) {
        if (tok.length() != 6) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 115 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 99 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i++) | 0x20) == 110 && (tok.charAt(i) | 0x20) == 100;
    }

    public static boolean isSelectKeyword(CharSequence tok) {
        if (tok.length() != 6) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 115 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 108 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 99 && (tok.charAt(i) | 0x20) == 116;
    }

    public static boolean isSemicolon(CharSequence token) {
        return Chars.equals(token, ';');
    }

    public static boolean isSetKeyword(CharSequence tok) {
        if (tok.length() != 3) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 115 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i) | 0x20) == 116;
    }

    public static boolean isStandardConformingStrings(CharSequence tok) {
        if (tok.length() != 27) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 115 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 110 && (tok.charAt(i++) | 0x20) == 100 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 114 && (tok.charAt(i++) | 0x20) == 100 && tok.charAt(i++) == '_' && (tok.charAt(i++) | 0x20) == 99 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i++) | 0x20) == 110 && (tok.charAt(i++) | 0x20) == 102 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i++) | 0x20) == 114 && (tok.charAt(i++) | 0x20) == 109 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 110 && (tok.charAt(i++) | 0x20) == 103 && tok.charAt(i++) == '_' && (tok.charAt(i++) | 0x20) == 115 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 114 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 110 && (tok.charAt(i++) | 0x20) == 103 && (tok.charAt(i) | 0x20) == 115;
    }

    public static boolean isSumKeyword(CharSequence tok) {
        if (tok.length() != 3) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 115 && (tok.charAt(i++) | 0x20) == 117 && (tok.charAt(i) | 0x20) == 109;
    }

    public static boolean isSystemKeyword(CharSequence tok) {
        if (tok.length() != 6) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 115 && (tok.charAt(i++) | 0x20) == 121 && (tok.charAt(i++) | 0x20) == 115 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i) | 0x20) == 109;
    }

    public static boolean isTableKeyword(CharSequence tok) {
        if (tok.length() != 5) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 98 && (tok.charAt(i++) | 0x20) == 108 && (tok.charAt(i) | 0x20) == 101;
    }

    public static boolean isTablesKeyword(CharSequence tok) {
        if (tok.length() != 6) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 98 && (tok.charAt(i++) | 0x20) == 108 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i) | 0x20) == 115;
    }

    public static boolean isTextKeyword(CharSequence tok) {
        if (tok.length() != 4) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 120 && (tok.charAt(i) | 0x20) == 116;
    }

    public static boolean isTimeKeyword(CharSequence tok) {
        if (tok.length() != 4) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 109 && (tok.charAt(i) | 0x20) == 101;
    }

    public static boolean isTimestampKeyword(CharSequence tok) {
        if (tok.length() != 9) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 109 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 115 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 109 && (tok.charAt(i) | 0x20) == 112;
    }

    public static boolean isToKeyword(CharSequence tok) {
        if (tok.length() != 2) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i) | 0x20) == 111;
    }

    public static boolean isTransactionIsolation(CharSequence tok) {
        if (tok.length() != 21) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 114 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 110 && (tok.charAt(i++) | 0x20) == 115 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 99 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i++) | 0x20) == 110 && tok.charAt(i++) == '_' && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 115 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i++) | 0x20) == 108 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i) | 0x20) == 110;
    }

    public static boolean isTransactionKeyword(CharSequence tok) {
        if (tok.length() != 11) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 114 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 110 && (tok.charAt(i++) | 0x20) == 115 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 99 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i) | 0x20) == 110;
    }

    public static boolean isTrueKeyword(CharSequence tok) {
        if (tok.length() != 4) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 114 && (tok.charAt(i++) | 0x20) == 117 && (tok.charAt(i) | 0x20) == 101;
    }

    public static boolean isTxnKeyword(CharSequence tok) {
        if (tok.length() != 3) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 120 && (tok.charAt(i) | 0x20) == 110;
    }

    public static boolean isUnionKeyword(CharSequence tok) {
        if (tok.length() != 5) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 117 && (tok.charAt(i++) | 0x20) == 110 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i) | 0x20) == 110;
    }

    public static boolean isUnlockKeyword(CharSequence tok) {
        if (tok.length() != 6) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 117 && (tok.charAt(i++) | 0x20) == 110 && (tok.charAt(i++) | 0x20) == 108 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i++) | 0x20) == 99 && (tok.charAt(i) | 0x20) == 107;
    }

    public static boolean isUpdateKeyword(CharSequence tok) {
        if (tok.length() != 6) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 117 && (tok.charAt(i++) | 0x20) == 112 && (tok.charAt(i++) | 0x20) == 100 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i) | 0x20) == 101;
    }

    public static boolean isValuesKeyword(CharSequence tok) {
        if (tok.length() != 6) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 118 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 108 && (tok.charAt(i++) | 0x20) == 117 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i) | 0x20) == 115;
    }

    public static boolean isWalKeyword(CharSequence tok) {
        if (tok.length() != 3) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 119 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i) | 0x20) == 108;
    }

    public static boolean isWeekKeyword(CharSequence tok) {
        if (tok.length() != 4) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 119 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i) | 0x20) == 107;
    }

    public static boolean isWhereKeyword(CharSequence tok) {
        if (tok.length() != 5) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 119 && (tok.charAt(i++) | 0x20) == 104 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 114 && (tok.charAt(i) | 0x20) == 101;
    }

    public static boolean isWithKeyword(CharSequence tok) {
        if (tok.length() != 4) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 119 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i) | 0x20) == 104;
    }

    public static boolean isWithinKeyword(CharSequence tok) {
        if (tok == null || tok.length() != 6) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 119 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 104 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i) | 0x20) == 110;
    }

    public static boolean isWriterKeyword(CharSequence tok) {
        if (tok.length() != 6) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 119 && (tok.charAt(i++) | 0x20) == 114 && (tok.charAt(i++) | 0x20) == 105 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i) | 0x20) == 114;
    }

    public static boolean isYearKeyword(CharSequence tok) {
        if (tok.length() != 4) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 121 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i) | 0x20) == 114;
    }

    public static boolean isZoneKeyword(CharSequence tok) {
        if (tok.length() != 4) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 122 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i++) | 0x20) == 110 && (tok.charAt(i) | 0x20) == 101;
    }

    public static boolean startsWithGeoHashKeyword(CharSequence tok) {
        if (tok.length() < 7) {
            return false;
        }
        int i = 0;
        return SqlKeywords.isGeoHashKeyword(tok, i);
    }

    public static boolean validateExtractPart(CharSequence token) {
        return TIMESTAMP_PART_SET.contains(token);
    }

    private static boolean isGeoHashKeyword(CharSequence tok, int i) {
        return (tok.charAt(i++) | 0x20) == 103 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i++) | 0x20) == 104 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 115 && (tok.charAt(i) | 0x20) == 104;
    }

    static {
        TIMESTAMP_PART_SET.add("microseconds");
        TIMESTAMP_PART_SET.add("milliseconds");
        TIMESTAMP_PART_SET.add("second");
        TIMESTAMP_PART_SET.add("minute");
        TIMESTAMP_PART_SET.add("hour");
        TIMESTAMP_PART_SET.add("day");
        TIMESTAMP_PART_SET.add("doy");
        TIMESTAMP_PART_SET.add("dow");
        TIMESTAMP_PART_SET.add("week");
        TIMESTAMP_PART_SET.add("month");
        TIMESTAMP_PART_SET.add("quarter");
        TIMESTAMP_PART_SET.add("year");
        TIMESTAMP_PART_SET.add("isoyear");
        TIMESTAMP_PART_SET.add("isodow");
        TIMESTAMP_PART_SET.add("decade");
        TIMESTAMP_PART_SET.add("century");
        TIMESTAMP_PART_SET.add("millennium");
        TIMESTAMP_PART_SET.add("epoch");
    }
}

