/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.vm;

import io.questdb.cairo.vm.AbstractMemoryCR;
import io.questdb.cairo.vm.api.MemoryCARW;
import io.questdb.griffin.engine.LimitOverflowException;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Long256Acceptor;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import org.jetbrains.annotations.NotNull;

public class MemoryCARWImpl
extends AbstractMemoryCR
implements MemoryCARW,
Mutable {
    private static final Log LOG = LogFactory.getLog(MemoryCARWImpl.class);
    private final Long256Acceptor long256Acceptor = this::putLong256;
    private final int maxPages;
    private final int memoryTag;
    private long appendAddress = 0L;
    private long sizeMsb;

    public MemoryCARWImpl(long pageSize, int maxPages, int memoryTag) {
        this.memoryTag = memoryTag;
        this.maxPages = maxPages;
        this.setPageSize(pageSize);
    }

    @Override
    public long appendAddressFor(long bytes) {
        this.checkAndExtend(this.appendAddress + bytes);
        long result = this.appendAddress;
        this.appendAddress += bytes;
        return result;
    }

    @Override
    public long appendAddressFor(long offset, long bytes) {
        this.checkAndExtend(this.pageAddress + offset + bytes);
        return this.addressOf(offset);
    }

    @Override
    public void clear() {
        super.clear();
        if (this.pageAddress != 0L) {
            long baseLength = this.lim - this.pageAddress;
            Unsafe.free(this.pageAddress, baseLength, this.memoryTag);
            this.handleMemoryReleased();
            this.size = 0L;
        }
    }

    @Override
    public void close() {
        this.clear();
        this.pageAddress = 0L;
        this.lim = 0L;
        this.appendAddress = 0L;
    }

    @Override
    public void extend(long size) {
        this.checkAndExtend(this.pageAddress + size);
    }

    @Override
    public final long getAppendOffset() {
        return this.appendAddress - this.pageAddress;
    }

    @Override
    public long getExtendSegmentSize() {
        return 1L << (int)this.sizeMsb;
    }

    @Override
    public long getPageSize() {
        return this.getExtendSegmentSize();
    }

    @Override
    public void jumpTo(long offset) {
        this.checkAndExtend(this.pageAddress + offset);
        this.appendAddress = this.pageAddress + offset;
    }

    @Override
    public final void putLong256(@NotNull CharSequence hexString, int start, int end) {
        this.putLong256(hexString, start, end, this.long256Acceptor);
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public void skip(long bytes) {
        this.checkAndExtend(this.appendAddress + bytes);
        this.appendAddress += bytes;
    }

    @Override
    public void truncate() {
        this.extend0(0L);
        this.appendAddress = this.pageAddress;
    }

    @Override
    public void zero() {
        long baseLength = this.lim - this.pageAddress;
        Vect.memset(this.pageAddress, baseLength, 0);
    }

    private void checkAndExtend(long address) {
        assert (this.appendAddress <= this.lim);
        assert (address >= this.pageAddress);
        if (address <= this.lim) {
            return;
        }
        this.extend0(address - this.pageAddress);
    }

    private void extend0(long size) {
        long oldSize;
        long nPages = size > 0L ? (size - 1L >>> (int)this.sizeMsb) + 1L : 1L;
        if ((size = nPages << (int)this.sizeMsb) == (oldSize = this.size())) {
            return;
        }
        if (nPages > (long)this.maxPages) {
            throw LimitOverflowException.instance().put("Maximum number of pages (").put(this.maxPages).put(") breached in VirtualMemory");
        }
        long newBaseAddress = this.reallocateMemory(this.pageAddress, this.size(), size);
        if (oldSize > 0L) {
            LOG.debug().$("extended [oldBase=").$(this.pageAddress).$(", newBase=").$(newBaseAddress).$(", oldSize=").$(oldSize).$(", newSize=").$(size).$(']').$();
        }
        this.handleMemoryReallocation(newBaseAddress, size);
    }

    protected final void handleMemoryReallocation(long newBaseAddress, long newSize) {
        assert (newBaseAddress != 0L);
        long appendOffset = this.appendAddress - this.pageAddress;
        this.pageAddress = newBaseAddress;
        this.lim = this.pageAddress + newSize;
        this.appendAddress = this.pageAddress + appendOffset;
        if (this.appendAddress > this.lim) {
            this.appendAddress = this.lim;
        }
        this.size = newSize;
    }

    protected final void handleMemoryReleased() {
        this.pageAddress = 0L;
        this.lim = 0L;
        this.appendAddress = 0L;
        this.size = 0L;
    }

    protected long reallocateMemory(long currentBaseAddress, long currentSize, long newSize) {
        if (currentBaseAddress != 0L) {
            return Unsafe.realloc(currentBaseAddress, currentSize, newSize, this.memoryTag);
        }
        return Unsafe.malloc(newSize, this.memoryTag);
    }

    protected final void setPageSize(long size) {
        this.sizeMsb = Numbers.msb(Numbers.ceilPow2(size));
    }
}

