/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.map;

import io.questdb.cairo.map.FastMap;
import io.questdb.cairo.map.FastMapRecord;
import io.questdb.cairo.map.MapRecord;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.std.Unsafe;

public final class FastMapCursor
implements RecordCursor {
    private final int keyValueSize;
    private final FastMap map;
    private final FastMapRecord recordA;
    private final MapRecord recordB;
    private long address;
    private int count;
    private long limit;
    private int remaining;
    private long topAddress;

    FastMapCursor(FastMapRecord record, FastMap map) {
        this.recordA = record;
        this.recordB = record.clone();
        this.map = map;
        this.keyValueSize = map.keySize() != -1 ? map.keySize() + map.valueSize() : -1;
    }

    @Override
    public void close() {
        this.map.restoreInitialCapacity();
    }

    @Override
    public MapRecord getRecord() {
        return this.recordA;
    }

    @Override
    public MapRecord getRecordB() {
        return this.recordB;
    }

    @Override
    public boolean hasNext() {
        if (this.remaining > 0) {
            long address = this.address;
            this.address = this.keyValueSize == -1 ? address + (long)Unsafe.getUnsafe().getInt(address) : address + (long)this.keyValueSize;
            if ((this.address & 7L) != 0L) {
                this.address |= 7L;
                ++this.address;
            }
            --this.remaining;
            this.recordA.of(address, this.limit);
            return true;
        }
        return false;
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        ((FastMapRecord)record).of(atRowId, this.limit);
    }

    @Override
    public long size() {
        return this.map.size();
    }

    @Override
    public void toTop() {
        this.address = this.topAddress;
        this.remaining = this.count;
    }

    FastMapCursor init(long address, long limit, int count) {
        this.address = this.topAddress = address;
        this.limit = limit;
        this.remaining = this.count = count;
        return this;
    }
}

