/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.jetty.configuration.connector.alpn;

import java.util.List;
import javax.net.ssl.SSLEngine;
import org.apache.nifi.jetty.configuration.connector.alpn.StandardALPNProcessor;
import org.eclipse.jetty.alpn.server.ALPNServerConnection;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ssl.ALPNProcessor;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.NegotiatingServerConnectionFactory;

public class ALPNServerConnectionFactory
extends NegotiatingServerConnectionFactory {
    private static final String ALPN_PROTOCOL = "alpn";
    private final ALPNProcessor.Server processor = new StandardALPNProcessor();

    public ALPNServerConnectionFactory() {
        super(ALPN_PROTOCOL, new String[0]);
    }

    protected AbstractConnection newServerConnection(Connector connector, EndPoint endPoint, SSLEngine sslEngine, List<String> protocols, String defaultProtocol) {
        ALPNServerConnection connection = new ALPNServerConnection(connector, endPoint, sslEngine, protocols, defaultProtocol);
        this.processor.configure(sslEngine, (Connection)connection);
        return connection;
    }
}

