/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.repository.schema;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.nifi.repository.schema.FieldType;
import org.apache.nifi.repository.schema.RecordField;
import org.apache.nifi.repository.schema.Repetition;

public class MapRecordField
implements RecordField {
    private final String fieldName;
    private final RecordField keyField;
    private final RecordField valueField;
    private final Repetition repetition;
    private final List<RecordField> subFields;

    public MapRecordField(String fieldName, RecordField keyField, RecordField valueField, Repetition repetition) {
        this.fieldName = Objects.requireNonNull(fieldName);
        this.keyField = Objects.requireNonNull(keyField);
        this.valueField = Objects.requireNonNull(valueField);
        this.repetition = Objects.requireNonNull(repetition);
        this.subFields = new ArrayList<RecordField>(2);
        this.subFields.add(keyField);
        this.subFields.add(valueField);
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public FieldType getFieldType() {
        return FieldType.MAP;
    }

    @Override
    public Repetition getRepetition() {
        return this.repetition;
    }

    @Override
    public List<RecordField> getSubFields() {
        return this.subFields;
    }

    public RecordField getKeyField() {
        return this.keyField;
    }

    public RecordField getValueField() {
        return this.valueField;
    }

    public String toString() {
        return "MapRecordField[" + this.fieldName + "]";
    }
}

