/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.impl;

import org.apache.ftpserver.DataConnectionConfiguration;
import org.apache.ftpserver.impl.PassivePorts;
import org.apache.ftpserver.ssl.SslConfiguration;

public class DefaultDataConnectionConfiguration
implements DataConnectionConfiguration {
    private final int idleTime;
    private final SslConfiguration ssl;
    private final boolean activeEnabled;
    private final String activeLocalAddress;
    private final int activeLocalPort;
    private final boolean activeIpCheck;
    private final String passiveAddress;
    private final String passiveExternalAddress;
    private final PassivePorts passivePorts;
    private final boolean passiveIpCheck;
    private final boolean implicitSsl;

    public DefaultDataConnectionConfiguration(int idleTime, SslConfiguration ssl, boolean activeEnabled, boolean activeIpCheck, String activeLocalAddress, int activeLocalPort, String passiveAddress, PassivePorts passivePorts, String passiveExternalAddress, boolean passiveIpCheck, boolean implicitSsl) {
        this.idleTime = idleTime;
        this.ssl = ssl;
        this.activeEnabled = activeEnabled;
        this.activeIpCheck = activeIpCheck;
        this.activeLocalAddress = activeLocalAddress;
        this.activeLocalPort = activeLocalPort;
        this.passiveAddress = passiveAddress;
        this.passivePorts = passivePorts;
        this.passiveExternalAddress = passiveExternalAddress;
        this.passiveIpCheck = passiveIpCheck;
        this.implicitSsl = implicitSsl;
    }

    @Override
    public int getIdleTime() {
        return this.idleTime;
    }

    @Override
    public boolean isActiveEnabled() {
        return this.activeEnabled;
    }

    @Override
    public boolean isActiveIpCheck() {
        return this.activeIpCheck;
    }

    @Override
    public String getActiveLocalAddress() {
        return this.activeLocalAddress;
    }

    @Override
    public int getActiveLocalPort() {
        return this.activeLocalPort;
    }

    @Override
    public String getPassiveAddress() {
        return this.passiveAddress;
    }

    @Override
    public String getPassiveExernalAddress() {
        return this.passiveExternalAddress;
    }

    @Override
    public boolean isPassiveIpCheck() {
        return this.passiveIpCheck;
    }

    @Override
    public synchronized int requestPassivePort() {
        return this.passivePorts.reserveNextPort();
    }

    @Override
    public String getPassivePorts() {
        return this.passivePorts.toString();
    }

    @Override
    public synchronized void releasePassivePort(int port) {
        this.passivePorts.releasePort(port);
    }

    @Override
    public SslConfiguration getSslConfiguration() {
        return this.ssl;
    }

    @Override
    public boolean isImplicitSsl() {
        return this.implicitSsl;
    }
}

