/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jline;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Priority;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.services.MessageBuilder;
import org.apache.maven.api.services.MessageBuilderFactory;
import org.apache.maven.jline.MessageUtils;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.StyleResolver;

@Named
@Singleton
@Priority(value=10)
@Experimental
public class JLineMessageBuilderFactory
implements MessageBuilderFactory {
    private final StyleResolver resolver = new MavenStyleResolver();

    public boolean isColorEnabled() {
        return MessageUtils.isColorEnabled();
    }

    public int getTerminalWidth() {
        return MessageUtils.getTerminalWidth();
    }

    public MessageBuilder builder() {
        return this.builder(64);
    }

    public MessageBuilder builder(int size) {
        return new JlineMessageBuilder(this.resolver, size);
    }

    private static class MavenStyleResolver
    extends StyleResolver {
        private final Map<String, AttributedStyle> styles = new ConcurrentHashMap<String, AttributedStyle>();

        private MavenStyleResolver() {
            super(key -> {
                String v = System.getProperty("maven.style." + key);
                if (v == null) {
                    v = System.getProperty("style." + key);
                }
                return v;
            });
        }

        public AttributedStyle resolve(String spec) {
            return this.styles.computeIfAbsent(spec, this::doResolve);
        }

        public AttributedStyle resolve(String spec, String defaultSpec) {
            return this.resolve((String)(defaultSpec != null ? spec + ":-" + defaultSpec : spec));
        }

        private AttributedStyle doResolve(String spec) {
            String def = null;
            int i = spec.indexOf(":-");
            if (i != -1) {
                String[] parts = spec.split(":-");
                spec = parts[0].trim();
                def = parts[1].trim();
            }
            return super.resolve(spec, def);
        }
    }

    private static class JlineMessageBuilder
    implements MessageBuilder {
        private final StyleResolver styleResolver;
        private final AttributedStringBuilder builder;

        private JlineMessageBuilder(StyleResolver styleResolver, int size) {
            this.styleResolver = styleResolver;
            this.builder = new AttributedStringBuilder(size);
        }

        public MessageBuilder style(String style) {
            if (MessageUtils.isColorEnabled()) {
                this.builder.style(this.styleResolver.resolve(style));
            }
            return this;
        }

        public MessageBuilder resetStyle() {
            this.builder.style(AttributedStyle.DEFAULT);
            return this;
        }

        public MessageBuilder append(CharSequence cs) {
            this.builder.append(cs);
            return this;
        }

        public MessageBuilder append(CharSequence cs, int start, int end) {
            this.builder.append(cs, start, end);
            return this;
        }

        public MessageBuilder append(char c) {
            this.builder.append(c);
            return this;
        }

        public MessageBuilder setLength(int length) {
            this.builder.setLength(length);
            return this;
        }

        public String build() {
            return this.builder.toAnsi(MessageUtils.terminal);
        }

        public String toString() {
            return this.build();
        }
    }
}

