/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl;

import java.nio.file.Path;
import java.util.List;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.Session;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.model.Repository;
import org.apache.maven.api.model.RepositoryPolicy;
import org.apache.maven.api.services.RepositoryFactory;
import org.apache.maven.impl.DefaultLocalRepository;
import org.apache.maven.impl.DefaultRemoteRepository;
import org.apache.maven.impl.InternalSession;
import org.apache.maven.impl.Utils;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;

@Named
@Singleton
public class DefaultRepositoryFactory
implements RepositoryFactory {
    final RemoteRepositoryManager remoteRepositoryManager;

    @Inject
    public DefaultRepositoryFactory(RemoteRepositoryManager remoteRepositoryManager) {
        this.remoteRepositoryManager = remoteRepositoryManager;
    }

    public org.apache.maven.api.LocalRepository createLocal(Path path) {
        return new DefaultLocalRepository(new LocalRepository(path.toAbsolutePath()));
    }

    public RemoteRepository createRemote(String id, String url) {
        return new DefaultRemoteRepository(new RemoteRepository.Builder(id, "default", url).build());
    }

    public RemoteRepository createRemote(Repository repository) throws IllegalArgumentException {
        return new DefaultRemoteRepository(new RemoteRepository.Builder(repository.getId(), repository.getLayout(), repository.getUrl()).setReleasePolicy(DefaultRepositoryFactory.buildRepositoryPolicy(repository.getReleases())).setSnapshotPolicy(DefaultRepositoryFactory.buildRepositoryPolicy(repository.getSnapshots())).build());
    }

    public List<RemoteRepository> aggregate(Session session, List<RemoteRepository> dominant, List<RemoteRepository> recessive, boolean processRecessive) {
        InternalSession internalSession = InternalSession.from(Utils.nonNull(session, "session"));
        List repos = this.remoteRepositoryManager.aggregateRepositories(internalSession.getSession(), internalSession.toRepositories(Utils.nonNull(dominant, "dominant")), internalSession.toRepositories(Utils.nonNull(recessive, "recessive")), processRecessive);
        return repos.stream().map(DefaultRemoteRepository::new).toList();
    }

    public static org.eclipse.aether.repository.RepositoryPolicy buildRepositoryPolicy(RepositoryPolicy policy) {
        boolean enabled = true;
        String updatePolicy = "daily";
        String checksumPolicy = "fail";
        if (policy != null) {
            enabled = policy.isEnabled();
            if (policy.getUpdatePolicy() != null) {
                updatePolicy = policy.getUpdatePolicy();
            }
            if (policy.getChecksumPolicy() != null) {
                checksumPolicy = policy.getChecksumPolicy();
            }
        }
        return new org.eclipse.aether.repository.RepositoryPolicy(enabled, updatePolicy, checksumPolicy);
    }
}

