/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api;

import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.maven.api.Language;
import org.apache.maven.api.Project;
import org.apache.maven.api.ProjectScope;
import org.apache.maven.api.Version;
import org.apache.maven.api.annotations.Nonnull;

public interface SourceRoot {
    default public Path directory() {
        Path src = Path.of("src", new String[0]);
        return this.module().map(src::resolve).orElse(src).resolve(this.scope().id()).resolve(this.language().id());
    }

    default public List<String> includes() {
        return List.of();
    }

    default public List<String> excludes() {
        return List.of();
    }

    public PathMatcher matcher(Collection<String> var1, boolean var2);

    default public ProjectScope scope() {
        return ProjectScope.MAIN;
    }

    default public Language language() {
        return Language.JAVA_FAMILY;
    }

    default public Optional<String> module() {
        return Optional.empty();
    }

    default public Optional<Version> targetVersion() {
        return Optional.empty();
    }

    default public Optional<Path> targetPath() {
        return Optional.empty();
    }

    @Nonnull
    default public Path targetPath(@Nonnull Project project) {
        Optional<Path> targetPath = this.targetPath();
        return targetPath.filter(Path::isAbsolute).orElseGet(() -> {
            Path base = project.getOutputDirectory(this.scope());
            return targetPath.map(base::resolve).orElse(base);
        });
    }

    default public boolean stringFiltering() {
        return false;
    }

    default public boolean enabled() {
        return true;
    }
}

