<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->
---
layout: page
title: GSOC

    
---

# Google Summer of Code

Mahout has been mentoring students in Google Summer of Code (GSoC) for as long as
the project has existed.  To help students better understand what is
expected of them, this page lays out common advice, links and other tips
and tricks for successfully creating a GSoC proposal for Mahout.

Be warned, however, that GSoC, particularly at the Apache Software
Foundation (ASF), is fairly competitive.  Not only are you competing
against others within Mahout, but Mahout is competing with other projects
in the ASF.  Therefore, it is very important that proposals be well
referenced and well thought out.  Even if you don't get selected, consider
sticking around.  Open source is fun, a great career builder and can open up many
opportunities for you.

## Tips on Good Proposals

* Interact with the community before proposal time.  This is actually part
of how we rate proposals.  Having a good idea is just one part of the
process.  You must show you can communicate and work within the community
parameters.   You might even consider putting up a patch or two that shows
you get how things work.  See [How To Contribute](how-to-contribute.html).
* Since Machine Learning is fairly academic, be sure to cite your sources
in your proposal.
* Provide a realistic timeline.  Be sure you indicate what other
obligations you have during the summer.  It may seem worthwhile to lie
here, but we have failed students mid-term in the past because they did not
participate as they said they would.  Failing mid-term means not getting
paid.
* Do not mail mentors off list privately unless it is something truly
personal (most things are not).  This will likely decrease your chances of
being selected, not increase them.
* DO NOT BITE OFF MORE THAN YOU CAN CHEW.  Every year, there are a few
students who propose to implement 3-5 machine learning algorithms on
Map/Reduce, all in a two month period.	They NEVER get selected.   Be
realistic.  All successful projects to date follow, more or less, the
following formula:  Implement algorithm on Map/Reduce.	Write Unit Tests. 
Do some bigger scale tests.  Write 1 or 2 examples.  Write Wiki
documentation.	That's it.  Trust us, it takes a summer to do these things.


## What to expect once selected

* Just as in the proposals, almost all interaction should take place on the
mailing lists.	Only personal matters related to your whereabouts or your
evaluation will take place privately.
* Show up.  Ask questions.  Be engaged.  We don't care if you know it all
about what you are implementing.  We care about you contributing to open
source.  You learn.  We learn.	Win-win.
* Enjoy it!  Contributing to open source can open some amazing doors for
your career.  

<a name="GSOC-References"></a>
## References

 * [GSoC Home](http://code.google.com/soc/) - official GSoC page
 * [GSoC FAQ](http://socghop.appspot.com/document/show/gsoc_program/google/gsoc2010/faqs) - official FAQ
 * [Apache GSoC coordination](http://community.apache.org/gsoc.html) - official Apache GSoC documentation, especially important  if you want to become a mentor