/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Encapsulates information needed to utilize the s3 Gateway API- namely, the AWS credentials, the rest url of the s3 Gateway and the S3 bucket.")
public class ApiOzoneS3GatewayInfo {
    @SerializedName(value="awsAccessKey")
    private String awsAccessKey = null;
    @SerializedName(value="awsSecret")
    private String awsSecret = null;
    @SerializedName(value="restUrl")
    private String restUrl = null;
    @SerializedName(value="restUrls")
    private List<String> restUrls = null;
    @SerializedName(value="bucket")
    private String bucket = null;

    public ApiOzoneS3GatewayInfo awsAccessKey(String awsAccessKey) {
        this.awsAccessKey = awsAccessKey;
        return this;
    }

    @Schema(description="The AWS access key for a particular Ozone service")
    public String getAwsAccessKey() {
        return this.awsAccessKey;
    }

    public void setAwsAccessKey(String awsAccessKey) {
        this.awsAccessKey = awsAccessKey;
    }

    public ApiOzoneS3GatewayInfo awsSecret(String awsSecret) {
        this.awsSecret = awsSecret;
        return this;
    }

    @Schema(description="The AWS secret associated with the access key")
    public String getAwsSecret() {
        return this.awsSecret;
    }

    public void setAwsSecret(String awsSecret) {
        this.awsSecret = awsSecret;
    }

    public ApiOzoneS3GatewayInfo restUrl(String restUrl) {
        this.restUrl = restUrl;
        return this;
    }

    @Schema(description="The rest url, in host:port format, of the Ozone S3 Gateway. Always returns the first entry in the list of rest urls or null if list is null or zero-length.")
    public String getRestUrl() {
        return this.restUrl;
    }

    public void setRestUrl(String restUrl) {
        this.restUrl = restUrl;
    }

    public ApiOzoneS3GatewayInfo restUrls(List<String> restUrls) {
        this.restUrls = restUrls;
        return this;
    }

    public ApiOzoneS3GatewayInfo addRestUrlsItem(String restUrlsItem) {
        if (this.restUrls == null) {
            this.restUrls = new ArrayList<String>();
        }
        this.restUrls.add(restUrlsItem);
        return this;
    }

    @Schema(description="The list of rest urls, in host:port format, of the Ozone S3 Gateway")
    public List<String> getRestUrls() {
        return this.restUrls;
    }

    public void setRestUrls(List<String> restUrls) {
        this.restUrls = restUrls;
    }

    public ApiOzoneS3GatewayInfo bucket(String bucket) {
        this.bucket = bucket;
        return this;
    }

    @Schema(description="The Ozone address of the created S3 bucket")
    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiOzoneS3GatewayInfo apiOzoneS3GatewayInfo = (ApiOzoneS3GatewayInfo)o;
        return Objects.equals(this.awsAccessKey, apiOzoneS3GatewayInfo.awsAccessKey) && Objects.equals(this.awsSecret, apiOzoneS3GatewayInfo.awsSecret) && Objects.equals(this.restUrl, apiOzoneS3GatewayInfo.restUrl) && Objects.equals(this.restUrls, apiOzoneS3GatewayInfo.restUrls) && Objects.equals(this.bucket, apiOzoneS3GatewayInfo.bucket);
    }

    public int hashCode() {
        return Objects.hash(this.awsAccessKey, this.awsSecret, this.restUrl, this.restUrls, this.bucket);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiOzoneS3GatewayInfo {\n");
        sb.append("    awsAccessKey: ").append(this.toIndentedString(this.awsAccessKey)).append("\n");
        sb.append("    awsSecret: ").append(this.toIndentedString(this.awsSecret)).append("\n");
        sb.append("    restUrl: ").append(this.toIndentedString(this.restUrl)).append("\n");
        sb.append("    restUrls: ").append(this.toIndentedString(this.restUrls)).append("\n");
        sb.append("    bucket: ").append(this.toIndentedString(this.bucket)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

