/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="An HDFS snapshot descriptor.")
public class ApiHdfsSnapshot {
    @SerializedName(value="path")
    private String path = null;
    @SerializedName(value="snapshotName")
    private String snapshotName = null;
    @SerializedName(value="snapshotPath")
    private String snapshotPath = null;
    @SerializedName(value="creationTime")
    private String creationTime = null;

    public ApiHdfsSnapshot path(String path) {
        this.path = path;
        return this;
    }

    @Schema(description="Snapshotted path.")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public ApiHdfsSnapshot snapshotName(String snapshotName) {
        this.snapshotName = snapshotName;
        return this;
    }

    @Schema(description="Snapshot name.")
    public String getSnapshotName() {
        return this.snapshotName;
    }

    public void setSnapshotName(String snapshotName) {
        this.snapshotName = snapshotName;
    }

    public ApiHdfsSnapshot snapshotPath(String snapshotPath) {
        this.snapshotPath = snapshotPath;
        return this;
    }

    @Schema(description="Read-only. Fully qualified path for the snapshot version of \"path\". <p/> For example, if a snapshot \"s1\" is present at \"/a/.snapshot/s1, then the snapshot path corresponding to \"s1\" for path \"/a/b\" will be \"/a/.snapshot/s1/b\".")
    public String getSnapshotPath() {
        return this.snapshotPath;
    }

    public void setSnapshotPath(String snapshotPath) {
        this.snapshotPath = snapshotPath;
    }

    public ApiHdfsSnapshot creationTime(String creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    @Schema(description="Snapshot creation time.")
    public String getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(String creationTime) {
        this.creationTime = creationTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiHdfsSnapshot apiHdfsSnapshot = (ApiHdfsSnapshot)o;
        return Objects.equals(this.path, apiHdfsSnapshot.path) && Objects.equals(this.snapshotName, apiHdfsSnapshot.snapshotName) && Objects.equals(this.snapshotPath, apiHdfsSnapshot.snapshotPath) && Objects.equals(this.creationTime, apiHdfsSnapshot.creationTime);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.snapshotName, this.snapshotPath, this.creationTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiHdfsSnapshot {\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    snapshotName: ").append(this.toIndentedString(this.snapshotName)).append("\n");
        sb.append("    snapshotPath: ").append(this.toIndentedString(this.snapshotPath)).append("\n");
        sb.append("    creationTime: ").append(this.toIndentedString(this.creationTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

